package cn.com.duiba.tuia.risk.center.api.dto;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.io.Serializable;
import java.util.Date;

@ApiModel
public class QihuoRuleDetailDto implements Serializable {

    private static final long serialVersionUID = 4919051016802127324L;

    @ApiModelProperty("主键")
    private Long id;

    @ApiModelProperty("日期")
    private Date curDate;

    @ApiModelProperty("规则名称")
    private String ruleName;

    @ApiModelProperty("规则类型：0-踢单规则、1-过滤规则")
    private Integer ruleType;

    @ApiModelProperty("商品id：订单对应的商品id")
    private Long goodsId;

    @ApiModelProperty("商家id：订单对应的商家id")
    private Long merchantId;

    @ApiModelProperty("广告位id：订单对应的广告位id")
    private Long slotId;

    @ApiModelProperty("媒体ID")
    private Long mediaId;

    @ApiModelProperty("媒体名字")
    private String mediaName;

    @ApiModelProperty("总订单：该商家当日，总下单量（包含过滤订单）")
    private Integer totalOrderCount;

    @ApiModelProperty("过滤订单：该商家当日，命中过滤规则的订单量")
    private Integer filterOrderCount;

    @ApiModelProperty("标记订单：该商家当日，命中标记规则的订单量")
    private Integer markOrderCount;

    @ApiModelProperty("总作弊订单：该商家当日，过滤订单+标记订单")
    private Integer cheatOrderCount;

    @ApiModelProperty("出单数")
    private Integer sendOrderCount;

    @ApiModelProperty("签收数")
    private Integer signingCount;

    @ApiModelProperty("创建时间")
    private Date gmtCreate;

    @ApiModelProperty("更新时间")
    private Date gmtModified;

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Date getCurDate() {
        return curDate;
    }

    public void setCurDate(Date curDate) {
        this.curDate = curDate;
    }

    public String getRuleName() {
        return ruleName;
    }

    public void setRuleName(String ruleName) {
        this.ruleName = ruleName;
    }

    public Integer getRuleType() {
        return ruleType;
    }

    public void setRuleType(Integer ruleType) {
        this.ruleType = ruleType;
    }

    public Long getGoodsId() {
        return goodsId;
    }

    public void setGoodsId(Long goodsId) {
        this.goodsId = goodsId;
    }

    public Long getMerchantId() {
        return merchantId;
    }

    public void setMerchantId(Long merchantId) {
        this.merchantId = merchantId;
    }

    public Long getSlotId() {
        return slotId;
    }

    public void setSlotId(Long slotId) {
        this.slotId = slotId;
    }

    public Integer getTotalOrderCount() {
        return totalOrderCount;
    }

    public void setTotalOrderCount(Integer totalOrderCount) {
        this.totalOrderCount = totalOrderCount;
    }

    public Integer getFilterOrderCount() {
        return filterOrderCount;
    }

    public void setFilterOrderCount(Integer filterOrderCount) {
        this.filterOrderCount = filterOrderCount;
    }

    public Integer getMarkOrderCount() {
        return markOrderCount;
    }

    public void setMarkOrderCount(Integer markOrderCount) {
        this.markOrderCount = markOrderCount;
    }

    public Integer getCheatOrderCount() {
        return cheatOrderCount;
    }

    public void setCheatOrderCount(Integer cheatOrderCount) {
        this.cheatOrderCount = cheatOrderCount;
    }

    public Integer getSendOrderCount() {
        return sendOrderCount;
    }

    public void setSendOrderCount(Integer sendOrderCount) {
        this.sendOrderCount = sendOrderCount;
    }

    public Integer getSigningCount() {
        return signingCount;
    }

    public void setSigningCount(Integer signingCount) {
        this.signingCount = signingCount;
    }

    public Date getGmtCreate() {
        return gmtCreate;
    }

    public void setGmtCreate(Date gmtCreate) {
        this.gmtCreate = gmtCreate;
    }

    public Date getGmtModified() {
        return gmtModified;
    }

    public void setGmtModified(Date gmtModified) {
        this.gmtModified = gmtModified;
    }

    public Long getMediaId() {
        return mediaId;
    }

    public void setMediaId(Long mediaId) {
        this.mediaId = mediaId;
    }

    public String getMediaName() {
        return mediaName;
    }

    public void setMediaName(String mediaName) {
        this.mediaName = mediaName;
    }
}
