package cn.com.duiba.tuia.risk.center.api.dto;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.io.Serializable;
import java.util.Date;

@ApiModel
public class SlotReviewDiffDto implements Serializable {

    private static final long serialVersionUID = -3178743168099058436L;

    @ApiModelProperty("id")
    private Long id;

    @ApiModelProperty("广告ID")
    private Long advertId;

    @ApiModelProperty("巡查时间")
    private Date reviewTime;

    @ApiModelProperty("1-拒绝，2-通过，3-敏感词待审")
    private Integer reviewStatus;

    @ApiModelProperty("日期")
    private Date curDate;

    @ApiModelProperty("URL")
    private String lastUrl;

    @ApiModelProperty("URL")
    private String currentUrl;

    @ApiModelProperty("差异度")
    private Integer diff;

    @ApiModelProperty("敏感词")
    private String violationWords;

    @ApiModelProperty("url类型 0-落地页 1-二次跳转页面")
    private Integer urlType;

    @ApiModelProperty("url")
    private String landingUrl;

    @ApiModelProperty("图片P哈希值")
    private String hashDegree;

    @ApiModelProperty("创建时间")
    private Date gmtCreate;

    @ApiModelProperty("修改时间")
    private Date gmtModified;

    @ApiModelProperty("广告主名称")
    private String advertMaster;

    @ApiModelProperty("代理商")
    private String agent;

    @ApiModelProperty("当日消耗")
    private Long consume;

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Long getAdvertId() {
        return advertId;
    }

    public void setAdvertId(Long advertId) {
        this.advertId = advertId;
    }

    public Date getReviewTime() {
        return reviewTime;
    }

    public void setReviewTime(Date reviewTime) {
        this.reviewTime = reviewTime;
    }

    public Integer getReviewStatus() {
        return reviewStatus;
    }

    public void setReviewStatus(Integer reviewStatus) {
        this.reviewStatus = reviewStatus;
    }

    public String getLastUrl() {
        return lastUrl;
    }

    public void setLastUrl(String lastUrl) {
        this.lastUrl = lastUrl;
    }

    public String getCurrentUrl() {
        return currentUrl;
    }

    public void setCurrentUrl(String currentUrl) {
        this.currentUrl = currentUrl;
    }

    public Integer getDiff() {
        return diff;
    }

    public void setDiff(Integer diff) {
        this.diff = diff;
    }

    public String getViolationWords() {
        return violationWords;
    }

    public void setViolationWords(String violationWords) {
        this.violationWords = violationWords;
    }

    public Integer getUrlType() {
        return urlType;
    }

    public void setUrlType(Integer urlType) {
        this.urlType = urlType;
    }

    public String getLandingUrl() {
        return landingUrl;
    }

    public void setLandingUrl(String landingUrl) {
        this.landingUrl = landingUrl;
    }

    public String getHashDegree() {
        return hashDegree;
    }

    public void setHashDegree(String hashDegree) {
        this.hashDegree = hashDegree;
    }

    public Date getGmtCreate() {
        return gmtCreate;
    }

    public void setGmtCreate(Date gmtCreate) {
        this.gmtCreate = gmtCreate;
    }

    public Date getGmtModified() {
        return gmtModified;
    }

    public void setGmtModified(Date gmtModified) {
        this.gmtModified = gmtModified;
    }

    public Date getCurDate() {
        return curDate;
    }

    public void setCurDate(Date curDate) {
        this.curDate = curDate;
    }

    public String getAdvertMaster() {
        return advertMaster;
    }

    public void setAdvertMaster(String advertMaster) {
        this.advertMaster = advertMaster;
    }

    public String getAgent() {
        return agent;
    }

    public void setAgent(String agent) {
        this.agent = agent;
    }

    public Long getConsume() {
        return consume;
    }

    public void setConsume(Long consume) {
        this.consume = consume;
    }
}
