package cn.com.duiba.tuia.risk.center.api.dto;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.io.Serializable;
import java.util.Date;

/**
 * 波动分析
 */
@ApiModel
public class WaveAnalysisRsp implements Serializable {

    private static final long serialVersionUID = 6871619136882550449L;

    @ApiModelProperty("唯一建")
    private Long id;

    @ApiModelProperty("日期")
    private Date curDate;

    @ApiModelProperty("规则ID")
    private String ruleId;

    @ApiModelProperty("规则名字")
    private String ruleName;

    @ApiModelProperty("规则类型，0-A类规则 1-C类规则-实时 2-C类规则离线")
    private Integer ruleType;

    @ApiModelProperty("广告位ID")
    private Long slotId;

    @ApiModelProperty("广告位名字")
    private String slotName;

    @ApiModelProperty("媒体id")
    private Long appId;

    @ApiModelProperty("作弊消耗")
    private Long cheatConsume;

    @ApiModelProperty("对比日期作弊消耗")
    private Long compareCheatConsume;

    @ApiModelProperty("作弊消耗占比(大盘)")
    private Double cheatConsumePercent;

    @ApiModelProperty("对比日期作弊消耗占比(大盘)")
    private Double compareCheatConsumePercent;

    @ApiModelProperty("作弊消耗差异值")
    private Long cheatConsumeDiff;

    @ApiModelProperty("作弊消耗占比差异值")
    private Double cheatConsumePercentDiff;

    @ApiModelProperty("作弊消耗占比(广告位)")
    private Double slotCheatPercent;

    @ApiModelProperty("对比日期作弊消耗占比(广告位)")
    private Double compareSlotCheatPercent;

    @ApiModelProperty("作弊消耗占比差异值(广告位)")
    private Double slotCheatPercentDiff;

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Date getCurDate() {
        return curDate;
    }

    public void setCurDate(Date curDate) {
        this.curDate = curDate;
    }

    public String getRuleId() {
        return ruleId;
    }

    public void setRuleId(String ruleId) {
        this.ruleId = ruleId;
    }

    public String getRuleName() {
        return ruleName;
    }

    public void setRuleName(String ruleName) {
        this.ruleName = ruleName;
    }

    public Integer getRuleType() {
        return ruleType;
    }

    public void setRuleType(Integer ruleType) {
        this.ruleType = ruleType;
    }

    public Long getSlotId() {
        return slotId;
    }

    public void setSlotId(Long slotId) {
        this.slotId = slotId;
    }

    public String getSlotName() {
        return slotName;
    }

    public void setSlotName(String slotName) {
        this.slotName = slotName;
    }

    public Long getAppId() {
        return appId;
    }

    public void setAppId(Long appId) {
        this.appId = appId;
    }

    public Long getCheatConsume() {
        return cheatConsume;
    }

    public void setCheatConsume(Long cheatConsume) {
        this.cheatConsume = cheatConsume;
    }

    public Long getCompareCheatConsume() {
        return compareCheatConsume;
    }

    public void setCompareCheatConsume(Long compareCheatConsume) {
        this.compareCheatConsume = compareCheatConsume;
    }

    public Double getCheatConsumePercent() {
        return cheatConsumePercent;
    }

    public void setCheatConsumePercent(Double cheatConsumePercent) {
        this.cheatConsumePercent = cheatConsumePercent;
    }

    public Double getCompareCheatConsumePercent() {
        return compareCheatConsumePercent;
    }

    public void setCompareCheatConsumePercent(Double compareCheatConsumePercent) {
        this.compareCheatConsumePercent = compareCheatConsumePercent;
    }

    public Long getCheatConsumeDiff() {
        return cheatConsumeDiff;
    }

    public void setCheatConsumeDiff(Long cheatConsumeDiff) {
        this.cheatConsumeDiff = cheatConsumeDiff;
    }

    public Double getCheatConsumePercentDiff() {
        return cheatConsumePercentDiff;
    }

    public void setCheatConsumePercentDiff(Double cheatConsumePercentDiff) {
        this.cheatConsumePercentDiff = cheatConsumePercentDiff;
    }

    public Double getSlotCheatPercent() {
        return slotCheatPercent;
    }

    public void setSlotCheatPercent(Double slotCheatPercent) {
        this.slotCheatPercent = slotCheatPercent;
    }

    public Double getCompareSlotCheatPercent() {
        return compareSlotCheatPercent;
    }

    public void setCompareSlotCheatPercent(Double compareSlotCheatPercent) {
        this.compareSlotCheatPercent = compareSlotCheatPercent;
    }

    public Double getSlotCheatPercentDiff() {
        return slotCheatPercentDiff;
    }

    public void setSlotCheatPercentDiff(Double slotCheatPercentDiff) {
        this.slotCheatPercentDiff = slotCheatPercentDiff;
    }
}

