package cn.com.duiba.tuia.risk.center.api.remoteservice;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.risk.center.api.dto.ViolationWordDto;
import cn.com.duiba.tuia.risk.center.api.dto.req.ViolationWordReq;

import java.util.List;

@AdvancedFeignClient
public interface RemoteViolationWordService {

    boolean add(ViolationWordDto dto);

    boolean update(ViolationWordDto dto);

    boolean delete(long id);

    List<ViolationWordDto> list(ViolationWordReq req);

    ViolationWordDto get(long id);

    /**
     * 根据敏感词行业表id列表查询敏感词信息
     * @param industryTags
     * @return
     */
    List<ViolationWordDto> getListByWordTagId(List<String> industryTags);

    ViolationWordDto getByNameAndTag(String name, String tag);
}
