package cn.com.duiba.tuia.risk.center.api.dto;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;

/**
* 媒体分成监控表
*/
@ApiModel
public class SlotDivideMonitorDto implements Serializable {

    private static final long serialVersionUID = 5282303969736811964L;

    /**
    * 
    */
    private Long id;

    @ApiModelProperty("日期")
    private Date curDate;

    @ApiModelProperty("广告位ID")
    private Long slotId;

    @ApiModelProperty("广告位名称")
    private String slotName;

    @ApiModelProperty("媒体id")
    private Long appId;

    @ApiModelProperty("媒体名称")
    private String appName;

    @ApiModelProperty("广告位消耗")
    private Long slotConsume;

    @ApiModelProperty("广告位实际分成比例")
    private BigDecimal divideRate;

    @ApiModelProperty("分成比例差值")
    private BigDecimal divideRateDiff;

    @ApiModelProperty("广告位分成收入")
    private Long divideIncome;

    @ApiModelProperty("分成收入差值")
    private Long divideIncomeDiff;

    @ApiModelProperty("作弊分成比例差值")
    private BigDecimal cheatRateDiff;

    @ApiModelProperty("昨日参考调整金额")
    private Long adjustAmount;

    @ApiModelProperty("消耗收入波动值")
    private Long waveConsume;

    @ApiModelProperty("分成是否合理 初始值: 0-合理 1-不合理")
    private Integer originIsRation;

    @ApiModelProperty("分成是否合理 页面显示值: 0-合理 1-不合理")
    private Integer isRation;

    @ApiModelProperty("监控规则：C1,L1,F1,F2")
    private String monitorRule;

    @ApiModelProperty("媒体运营")
    private String mediaOperate;

    @ApiModelProperty("复查结果")
    private String reviewResult;

    @ApiModelProperty("记录创建时间")
    private Date gmtCreate;

    @ApiModelProperty("记录修改时间")
    private Date gmtModified;

    @ApiModelProperty("不合理次数")
    private Integer unRationCount;

    @ApiModelProperty("作弊消耗占比")
    private BigDecimal cheatFeeRate;

    @ApiModelProperty("30日拒绝核减占比")
    private BigDecimal refuseRate;

    @ApiModelProperty("新上线广告位: 1_是、0_否")
    private Integer newType;

    @ApiModelProperty("ARPU值:消耗/发券pv")
    private BigDecimal arpuRate;

    @ApiModelProperty("预估分成比例")
    private BigDecimal todayDivideRate;


    public void setId(Long id) {
        this.id = id;
    }

    public Long getId() {
        return id;
    }

    public void setCurDate(Date curDate) {
        this.curDate = curDate;
    }

    public Date getCurDate() {
        return curDate;
    }

    public void setSlotId(Long slotId) {
        this.slotId = slotId;
    }

    public Long getSlotId() {
        return slotId;
    }

    public void setSlotName(String slotName) {
        this.slotName = slotName;
    }

    public String getSlotName() {
        return slotName;
    }

    public void setAppId(Long appId) {
        this.appId = appId;
    }

    public Long getAppId() {
        return appId;
    }

    public void setAppName(String appName) {
        this.appName = appName;
    }

    public String getAppName() {
        return appName;
    }

    public void setSlotConsume(Long slotConsume) {
        this.slotConsume = slotConsume;
    }

    public Long getSlotConsume() {
        return slotConsume;
    }

    public void setDivideRate(BigDecimal divideRate) {
        this.divideRate = divideRate;
    }

    public BigDecimal getDivideRate() {
        return divideRate;
    }

    public void setDivideRateDiff(BigDecimal divideRateDiff) {
        this.divideRateDiff = divideRateDiff;
    }

    public BigDecimal getDivideRateDiff() {
        return divideRateDiff;
    }

    public void setDivideIncome(Long divideIncome) {
        this.divideIncome = divideIncome;
    }

    public Long getDivideIncome() {
        return divideIncome;
    }

    public void setDivideIncomeDiff(Long divideIncomeDiff) {
        this.divideIncomeDiff = divideIncomeDiff;
    }

    public Long getDivideIncomeDiff() {
        return divideIncomeDiff;
    }

    public void setCheatRateDiff(BigDecimal cheatRateDiff) {
        this.cheatRateDiff = cheatRateDiff;
    }

    public BigDecimal getCheatRateDiff() {
        return cheatRateDiff;
    }

    public void setAdjustAmount(Long adjustAmount) {
        this.adjustAmount = adjustAmount;
    }

    public Long getAdjustAmount() {
        return adjustAmount;
    }

    public void setWaveConsume(Long waveConsume) {
        this.waveConsume = waveConsume;
    }

    public Long getWaveConsume() {
        return waveConsume;
    }

    public void setOriginIsRation(Integer originIsRation) {
        this.originIsRation = originIsRation;
    }

    public Integer getOriginIsRation() {
        return originIsRation;
    }

    public void setIsRation(Integer isRation) {
        this.isRation = isRation;
    }

    public Integer getIsRation() {
        return isRation;
    }

    public void setMonitorRule(String monitorRule) {
        this.monitorRule = monitorRule;
    }

    public String getMonitorRule() {
        return monitorRule;
    }

    public void setMediaOperate(String mediaOperate) {
        this.mediaOperate = mediaOperate;
    }

    public String getMediaOperate() {
        return mediaOperate;
    }

    public void setReviewResult(String reviewResult) {
        this.reviewResult = reviewResult;
    }

    public String getReviewResult() {
        return reviewResult;
    }

    public void setGmtCreate(Date gmtCreate) {
        this.gmtCreate = gmtCreate;
    }

    public Date getGmtCreate() {
        return gmtCreate;
    }

    public void setGmtModified(Date gmtModified) {
        this.gmtModified = gmtModified;
    }

    public Date getGmtModified() {
        return gmtModified;
    }

    public Integer getUnRationCount() {
        return unRationCount;
    }

    public void setUnRationCount(Integer unRationCount) {
        this.unRationCount = unRationCount;
    }

    public BigDecimal getCheatFeeRate() {
        return cheatFeeRate;
    }

    public void setCheatFeeRate(BigDecimal cheatFeeRate) {
        this.cheatFeeRate = cheatFeeRate;
    }

    public BigDecimal getRefuseRate() {
        return refuseRate;
    }

    public void setRefuseRate(BigDecimal refuseRate) {
        this.refuseRate = refuseRate;
    }

    public Integer getNewType() {
        return newType;
    }

    public void setNewType(Integer newType) {
        this.newType = newType;
    }

    public BigDecimal getArpuRate() {
        return arpuRate;
    }

    public void setArpuRate(BigDecimal arpuRate) {
        this.arpuRate = arpuRate;
    }

    public BigDecimal getTodayDivideRate() {
        return todayDivideRate;
    }

    public void setTodayDivideRate(BigDecimal todayDivideRate) {
        this.todayDivideRate = todayDivideRate;
    }
}

