package cn.com.duiba.tuia.risk.center.api.remoteservice;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.risk.center.api.common.PageResultDto;
import cn.com.duiba.tuia.risk.center.api.dto.EngineRuleLogDto;
import cn.com.duiba.tuia.risk.center.api.dto.MediaBlackDto;
import cn.com.duiba.tuia.risk.center.api.dto.WechatDomainLogDto;
import cn.com.duiba.tuia.risk.center.api.dto.req.EngineRuleLogParam;
import cn.com.duiba.tuia.risk.center.api.dto.req.MediaBlackParam;

import java.util.List;

@AdvancedFeignClient
public interface RemoteMediaBlackService {

    /**
     * 媒体黑名单信息保存
     * @param mediaBlackDto
     * @return
     */
    Integer save(MediaBlackDto mediaBlackDto);

    /**
     * 媒体黑名单信息删除
     * @param id
     * @return
     */
    Integer deleteById(Long id);

    /**
     * 媒体黑名单信息更新
     * @param mediaBlackDto
     * @return
     */
    Integer updateById(MediaBlackDto mediaBlackDto);

    /**
     * 根据媒体账户id查询媒体黑名单信息
     * @param mediaId
     * @return
     */
    MediaBlackDto getByMedia(Long mediaId);

    /**
     * 分页查询规则媒体黑名单信息
     * @param param
     * @return
     */
    PageResultDto<MediaBlackDto> queryPage(MediaBlackParam param);

}
