package cn.com.duiba.tuia.risk.center.api.dto.req;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import javax.validation.constraints.NotNull;
import java.io.Serializable;

@ApiModel
public class EngineStrategyReq implements Serializable {

    @ApiModelProperty("场景id")
    @NotNull
    private Long sceneId;

    @ApiModelProperty("策略标识")
    @NotNull
    private String strategyKey;

    @ApiModelProperty("策略名称")
    @NotNull
    private String strategyName;

    @ApiModelProperty("策略类型")
    private Integer strategyType;

    @ApiModelProperty("是否启用，未启用：0，启用：1")
    @NotNull
    private Integer status;

    @ApiModelProperty("描述")
    private String description;

    @ApiModelProperty("分数1")
    private Double score1;

    @ApiModelProperty("分数2")
    private Double score2;

    @ApiModelProperty("分数3")
    private Double score3;

    @ApiModelProperty("分数4")
    private Double score4;

    //黑名单时效分，用于确定黑名单保存时效
    @ApiModelProperty("黑名单时效分")
    private Double timeScore;

    public String getStrategyKey() {
        return strategyKey;
    }

    public void setStrategyKey(String strategyKey) {
        this.strategyKey = strategyKey;
    }

    public String getStrategyName() {
        return strategyName;
    }

    public void setStrategyName(String strategyName) {
        this.strategyName = strategyName;
    }

    public Integer getStatus() {
        return status;
    }

    public void setStatus(Integer status) {
        this.status = status;
    }

    public String getDescription() {
        return description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public Long getSceneId() {
        return sceneId;
    }

    public void setSceneId(Long sceneId) {
        this.sceneId = sceneId;
    }

    public Double getScore1() {
        return score1;
    }

    public void setScore1(Double score1) {
        this.score1 = score1;
    }

    public Double getScore2() {
        return score2;
    }

    public void setScore2(Double score2) {
        this.score2 = score2;
    }

    public Double getScore3() {
        return score3;
    }

    public void setScore3(Double score3) {
        this.score3 = score3;
    }

    public Double getScore4() {
        return score4;
    }

    public void setScore4(Double score4) {
        this.score4 = score4;
    }

    public Integer getStrategyType() {
        return strategyType;
    }

    public void setStrategyType(Integer strategyType) {
        this.strategyType = strategyType;
    }

    public Double getTimeScore() {
        return timeScore;
    }

    public void setTimeScore(Double timeScore) {
        this.timeScore = timeScore;
    }
}
