package cn.com.duiba.tuia.risk.center.api.enums;

import java.util.Objects;
import java.util.stream.Stream;

/**
 * 域名类型
 *
 * @author peanut.huang
 * @date 2019/10/25
 * @since JDK 1.8
 */
public enum DomainTypeEnum {

    /**
     *
     */
    BAIQI_LAND_PAGE(1, "百奇落地页"),

    JIMU_LAND_PAGE(2, "积木落地页"),

    BAIQI_CASHIER_PAGE(3, "百奇收银台页面")


    ;

    /**
     * 状态值
     */
    private Integer status;

    /**
     * 描述
     */
    private String  desc;

    DomainTypeEnum(Integer status, String desc) {
        this.status = status;
        this.desc = desc;
    }

    public Integer getStatus() {
        return status;
    }

    public String getDesc() {
        return desc;
    }



    /**
     * 根据状态值获取枚举
     *
     * @param status 状态值
     * @return
     */
    public static DomainTypeEnum findByStatus(Integer status){
        if(status == null){
            return null;
        }
        return Stream.of(DomainTypeEnum.values()).filter(e -> Objects.equals(e.getStatus(), status)).findFirst().orElse(null);
    }
}
