/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.tuia.risk.center.api.enums;

import java.util.Arrays;
import java.util.Map;
import java.util.stream.Collectors;

public enum DomainPlatformEnum {
    WECHAT(1, "\u5fae\u4fe1"),
    ALIPAY(2, "\u652f\u4ed8\u5b9d-\u5b89\u5353"),
    ALIPAY_IOS(3, "\u652f\u4ed8\u5b9d-IOS");

    private Integer type;
    private String desc;
    private static Map<Integer, DomainPlatformEnum> map;

    private DomainPlatformEnum(Integer type, String desc) {
        this.type = type;
        this.desc = desc;
    }

    public Integer getType() {
        return this.type;
    }

    public String getDesc() {
        return this.desc;
    }

    public static DomainPlatformEnum of(Integer type) {
        return map.getOrDefault(type, ALIPAY_IOS);
    }

    public static String getDescByType(Integer type) {
        return map.getOrDefault(type, WECHAT).getDesc();
    }

    static {
        map = Arrays.stream(DomainPlatformEnum.values()).collect(Collectors.toMap(DomainPlatformEnum::getType, v -> v));
    }
}

