/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.tuia.risk.center.api.util;

import java.awt.Graphics2D;
import java.awt.color.ColorSpace;
import java.awt.image.BufferedImage;
import java.awt.image.ColorConvertOp;
import java.io.IOException;
import java.io.InputStream;
import javax.imageio.ImageIO;

public class ImagePHashUtil {
    private ColorConvertOp colorConvert = new ColorConvertOp(ColorSpace.getInstance(1003), null);
    private int size = 32;
    private int smallerSize = 8;
    private double[] c;
    private static final ImagePHashUtil imagePHashUtil = new ImagePHashUtil();

    public ImagePHashUtil() {
        this.initCoefficients();
    }

    public static int distanceValue(String hashDegree1, String hashDegree2) {
        return imagePHashUtil.distance(hashDegree1, hashDegree2);
    }

    public static String getHashValue(InputStream is) throws IOException {
        return imagePHashUtil.getHash(is);
    }

    public int distance(String s1, String s2) {
        int counter = 0;
        for (int k = 0; k < s1.length(); ++k) {
            if (s1.charAt(k) == s2.charAt(k)) continue;
            ++counter;
        }
        return counter;
    }

    public String getHash(InputStream is) throws IOException {
        BufferedImage img = ImageIO.read(is);
        img = this.resize(img, this.size, this.size);
        img = this.grayscale(img);
        double[][] vals = new double[this.size][this.size];
        for (int x = 0; x < img.getWidth(); ++x) {
            for (int y = 0; y < img.getHeight(); ++y) {
                vals[x][y] = this.getBlue(img, x, y);
            }
        }
        img = null;
        double[][] dctVals = this.applyDCT(vals);
        double total = this.getTotal(dctVals);
        double avg = total / (double)(this.smallerSize * this.smallerSize - 1);
        StringBuilder hash = new StringBuilder();
        for (int x = 0; x < this.smallerSize; ++x) {
            for (int y = 0; y < this.smallerSize; ++y) {
                if (x == 0 || y == 0) continue;
                hash.append(dctVals[x][y] > avg ? "1" : "0");
            }
        }
        dctVals = null;
        return hash.toString();
    }

    private double getTotal(double[][] dctVals) {
        double temp = 0.0;
        for (int x = 0; x < this.smallerSize; ++x) {
            for (int y = 0; y < this.smallerSize; ++y) {
                temp += dctVals[x][y];
            }
        }
        return temp -= dctVals[0][0];
    }

    private BufferedImage resize(BufferedImage image, int width, int height) {
        BufferedImage resizedImage = new BufferedImage(width, height, 2);
        Graphics2D g = resizedImage.createGraphics();
        g.drawImage(image, 0, 0, width, height, null);
        g.dispose();
        return resizedImage;
    }

    private BufferedImage grayscale(BufferedImage img) {
        this.colorConvert.filter(img, img);
        return img;
    }

    private int getBlue(BufferedImage img, int x, int y) {
        return img.getRGB(x, y) & 0xFF;
    }

    private void initCoefficients() {
        this.c = new double[this.size];
        for (int i = 1; i < this.size; ++i) {
            this.c[i] = 1.0;
        }
        this.c[0] = 1.0 / Math.sqrt(2.0);
    }

    private double[][] applyDCT(double[][] f) {
        int s = this.size;
        double[][] ff = new double[s][s];
        for (int u = 0; u < s; ++u) {
            for (int v = 0; v < s; ++v) {
                double sum = 0.0;
                for (int i = 0; i < s; ++i) {
                    for (int j = 0; j < s; ++j) {
                        sum += Math.cos((double)(2 * i + 1) / (2.0 * (double)s) * (double)u * Math.PI) * Math.cos((double)(2 * j + 1) / (2.0 * (double)s) * (double)v * Math.PI) * f[i][j];
                    }
                }
                ff[u][v] = sum *= this.c[u] * this.c[v] / 4.0;
            }
        }
        return ff;
    }
}

