package cn.com.duiba.tuia.risk.center.api.dto;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.io.Serializable;
import java.util.Date;

@ApiModel
public class DimensionAnalysisDetailDto implements Serializable {

    private static final long serialVersionUID = -7563028233285358748L;

    @ApiModelProperty("id")
    private Long id;

    @ApiModelProperty("日期")
    private Date curDate;

    @ApiModelProperty("维度，0-ip,1-device,2-ua")
    private Integer dimension;

    @ApiModelProperty("IP、device_id、UserAgent")
    private String metric;

    @ApiModelProperty("媒体ID")
    private Long appId;

    @ApiModelProperty("媒体名字")
    private String appName;

    @ApiModelProperty("广告位ID")
    private Long slotId;

    @ApiModelProperty("广告位名字")
    private String slotName;

    @ApiModelProperty("广告位访问UV")
    private Long sdkUv;

    @ApiModelProperty("活动参与UV")
    private Long participateUv;

    @ApiModelProperty("活动参与PV")
    private Long participatePv;

    @ApiModelProperty("发券量")
    private Long launchCount;

    @ApiModelProperty("券曝光量")
    private Long exposureCount;

    @ApiModelProperty("点击PV")
    private Long clickCount;

    @ApiModelProperty("落地页访问UV")
    private Long promoteVisitUv;

    @ApiModelProperty("落地页访问PV")
    private Long promoteVisitPv;

    @ApiModelProperty("落地页转化PV")
    private Long effectPv;

    @ApiModelProperty("ctr")
    private Double ctr;

    @ApiModelProperty("cvr")
    private Double cvr;

    /**
     * 总发券量
     */
    @ApiModelProperty("总发券量")
    private Long slotLaunchCount;

    /**
     * 发券量占比：发券量/广告位当天总发券量
     */
    @ApiModelProperty("发券量占比")
    private Double launchRate;

    @ApiModelProperty("创建时间")
    private Date gmtCreate;

    @ApiModelProperty("修改时间")
    private Date gmtModified;

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Date getCurDate() {
        return curDate;
    }

    public void setCurDate(Date curDate) {
        this.curDate = curDate;
    }

    public Integer getDimension() {
        return dimension;
    }

    public void setDimension(Integer dimension) {
        this.dimension = dimension;
    }

    public String getMetric() {
        return metric;
    }

    public void setMetric(String metric) {
        this.metric = metric;
    }

    public Long getSdkUv() {
        return sdkUv;
    }

    public void setSdkUv(Long sdkUv) {
        this.sdkUv = sdkUv;
    }

    public Long getParticipateUv() {
        return participateUv;
    }

    public void setParticipateUv(Long participateUv) {
        this.participateUv = participateUv;
    }

    public Long getParticipatePv() {
        return participatePv;
    }

    public void setParticipatePv(Long participatePv) {
        this.participatePv = participatePv;
    }

    public Long getLaunchCount() {
        return launchCount;
    }

    public void setLaunchCount(Long launchCount) {
        this.launchCount = launchCount;
    }

    public Long getExposureCount() {
        return exposureCount;
    }

    public void setExposureCount(Long exposureCount) {
        this.exposureCount = exposureCount;
    }

    public Long getClickCount() {
        return clickCount;
    }

    public void setClickCount(Long clickCount) {
        this.clickCount = clickCount;
    }

    public Long getPromoteVisitUv() {
        return promoteVisitUv;
    }

    public void setPromoteVisitUv(Long promoteVisitUv) {
        this.promoteVisitUv = promoteVisitUv;
    }

    public Long getPromoteVisitPv() {
        return promoteVisitPv;
    }

    public void setPromoteVisitPv(Long promoteVisitPv) {
        this.promoteVisitPv = promoteVisitPv;
    }

    public Long getEffectPv() {
        return effectPv;
    }

    public void setEffectPv(Long effectPv) {
        this.effectPv = effectPv;
    }

    public Double getCtr() {
        return ctr;
    }

    public void setCtr(Double ctr) {
        this.ctr = ctr;
    }

    public Double getCvr() {
        return cvr;
    }

    public void setCvr(Double cvr) {
        this.cvr = cvr;
    }

    public Date getGmtCreate() {
        return gmtCreate;
    }

    public void setGmtCreate(Date gmtCreate) {
        this.gmtCreate = gmtCreate;
    }

    public Date getGmtModified() {
        return gmtModified;
    }

    public void setGmtModified(Date gmtModified) {
        this.gmtModified = gmtModified;
    }

    public Long getAppId() {
        return appId;
    }

    public void setAppId(Long appId) {
        this.appId = appId;
    }

    public String getAppName() {
        return appName;
    }

    public void setAppName(String appName) {
        this.appName = appName;
    }

    public Long getSlotId() {
        return slotId;
    }

    public void setSlotId(Long slotId) {
        this.slotId = slotId;
    }

    public String getSlotName() {
        return slotName;
    }

    public void setSlotName(String slotName) {
        this.slotName = slotName;
    }


    public Long getSlotLaunchCount() {
        return slotLaunchCount;
    }

    public void setSlotLaunchCount(Long slotLaunchCount) {
        this.slotLaunchCount = slotLaunchCount;
    }

    public Double getLaunchRate() {
        return launchRate;
    }

    public void setLaunchRate(Double launchRate) {
        this.launchRate = launchRate;
    }


}
