package cn.com.duiba.tuia.risk.center.api.dto;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;

/**
* 大盘波动报警配置表
*/
@ApiModel
public class MarketAlarmConfigDto implements Serializable {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty("主键")
    private Long id;

    @ApiModelProperty("指标名称")
    private String targetName;

    @ApiModelProperty("波动率报警上限")
    private BigDecimal alarmUp;

    @ApiModelProperty("波动率报警下限")
    private BigDecimal alarmLow;

    @ApiModelProperty("报警状态:0-关闭;1-开启")
    private Integer alarmStatus;

    @ApiModelProperty("记录创建时间")
    private Date gmtCreate;

    @ApiModelProperty("记录修改时间")
    private Date gmtModified;


    public void setId(Long id) {
        this.id = id;
    }

    public Long getId() {
        return id;
    }

    public void setTargetName(String targetName) {
        this.targetName = targetName;
    }

    public String getTargetName() {
        return targetName;
    }

    public void setAlarmUp(BigDecimal alarmUp) {
        this.alarmUp = alarmUp;
    }

    public BigDecimal getAlarmUp() {
        return alarmUp;
    }

    public void setAlarmLow(BigDecimal alarmLow) {
        this.alarmLow = alarmLow;
    }

    public BigDecimal getAlarmLow() {
        return alarmLow;
    }

    public void setAlarmStatus(Integer alarmStatus) {
        this.alarmStatus = alarmStatus;
    }

    public Integer getAlarmStatus() {
        return alarmStatus;
    }

    public void setGmtCreate(Date gmtCreate) {
        this.gmtCreate = gmtCreate;
    }

    public Date getGmtCreate() {
        return gmtCreate;
    }

    public void setGmtModified(Date gmtModified) {
        this.gmtModified = gmtModified;
    }

    public Date getGmtModified() {
        return gmtModified;
    }

}

