package cn.com.duiba.tuia.risk.center.api.dto;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.io.Serializable;
import java.util.Date;
import java.util.List;

/**
 * 风控情报系统行业关键词库
 */
@ApiModel
public class RiskIndustryWordDto implements Serializable {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty("id")
    private Long id;

    @ApiModelProperty("行业")
    private String industryName;

    @ApiModelProperty("敏感词")
    private String wordName;

    @ApiModelProperty("修改者")
    private String editor;

    @ApiModelProperty("创建时间")
    private Date gmtCreate;

    @ApiModelProperty("修改时间")
    private Date gmtModified;

    @ApiModelProperty("关键词类型0:行业；1:资源")
    private Integer wordType;

    @ApiModelProperty("行业大类")
    private String industryFamily;

    @ApiModelProperty("父id：父id不等于0的为关键词行")
    private Long parentId;

    @ApiModelProperty("新行业名称")
    private String newIndustryName;

    @ApiModelProperty("新敏感词名称")
    private String newWordName;

    @ApiModelProperty("行业关键词列表")
    private List<String> wordNameList;

    @ApiModelProperty("资源关键词列表")
    private List<String> resourceWordList;

    public void setId(Long id) {
        this.id = id;
    }

    public Long getId() {
        return id;
    }

    public void setIndustryName(String industryName) {
        this.industryName = industryName;
    }

    public String getIndustryName() {
        return industryName;
    }

    public void setWordName(String wordName) {
        this.wordName = wordName;
    }

    public String getWordName() {
        return wordName;
    }

    public void setEditor(String editor) {
        this.editor = editor;
    }

    public String getEditor() {
        return editor;
    }

    public void setGmtCreate(Date gmtCreate) {
        this.gmtCreate = gmtCreate;
    }

    public Date getGmtCreate() {
        return gmtCreate;
    }

    public void setGmtModified(Date gmtModified) {
        this.gmtModified = gmtModified;
    }

    public Date getGmtModified() {
        return gmtModified;
    }

    public List<String> getWordNameList() {
        return wordNameList;
    }

    public void setWordNameList(List<String> wordNameList) {
        this.wordNameList = wordNameList;
    }

    public String getNewIndustryName() {
        return newIndustryName;
    }

    public void setNewIndustryName(String newIndustryName) {
        this.newIndustryName = newIndustryName;
    }

    public String getNewWordName() {
        return newWordName;
    }

    public void setNewWordName(String newWordName) {
        this.newWordName = newWordName;
    }

    public Integer getWordType() {
        return wordType;
    }

    public void setWordType(Integer wordType) {
        this.wordType = wordType;
    }

    public String getIndustryFamily() {
        return industryFamily;
    }

    public void setIndustryFamily(String industryFamily) {
        this.industryFamily = industryFamily;
    }

    public Long getParentId() {
        return parentId;
    }

    public void setParentId(Long parentId) {
        this.parentId = parentId;
    }

    public List<String> getResourceWordList() {
        return resourceWordList;
    }

    public void setResourceWordList(List<String> resourceWordList) {
        this.resourceWordList = resourceWordList;
    }
}

