package cn.com.duiba.tuia.risk.center.api.remoteservice;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.risk.center.api.common.PageResultDto;
import cn.com.duiba.tuia.risk.center.api.dto.CompetePatrolLogDto;
import cn.com.duiba.tuia.risk.center.api.dto.CompetePatrolLogParam;

import java.util.List;

@AdvancedFeignClient
public interface RemoteCompetePatrolLogService {

    PageResultDto<CompetePatrolLogDto> queryPage(CompetePatrolLogParam param);

    /**
     * 根据竞品id获取已保存的地域列表
     */
    List<String> getAllCity(Long competeId);

    /**
     * 保存竞品域名巡查日志信息
     */
    Integer save(CompetePatrolLogDto competePatrolLogDto);

    /**
     * 根据竞品id 获取竞品巡查次数
     */
    Integer getCountByCompeteId(Long competeId);

    Integer deleteById(Long id);

    Long getIdByParam(Long competeId);

    /**
     * 获取最新10000条数据的地域
     */
    List<String> getAllCityLimit();
}
