package cn.com.duiba.tuia.risk.center.api.remoteservice;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.risk.center.api.common.PageResultDto;
import cn.com.duiba.tuia.risk.center.api.dto.RiskIndustryWordDto;
import cn.com.duiba.tuia.risk.center.api.dto.req.ReqPageQuery;

import java.util.List;

@AdvancedFeignClient
public interface RemoteRiskIndustryWordService {

    /**
     * @Description: 查询行业或者关键词的数量
     * @Author: lijian
     * @Date: 2019/5/16
     */
    Integer getIndustryWordCount(Long parentId, String industryName, String wordName, Integer wordType);

    /**
     * @Description: 新增情报系统行业关键词
     * @Author: lijian
     * @Date: 2019/5/16
     */
    Integer save(RiskIndustryWordDto dto);

    /**
     * @Description: 更新情报系统行业关键词
     * @Author: lijian
     * @Date: 2019/5/16
     */
    Integer updateByParam(RiskIndustryWordDto dto);


    /**
     * @Description: 删除情报系统行业关键词
     * @Author: lijian
     * @Date: 2019/5/16
     */
    Integer deleteByParam(RiskIndustryWordDto dto);

    /**
     * @Description: 获取所有的行业列表
     * @Author: lijian
     * @Date: 2019/5/16
     */
    List<RiskIndustryWordDto> getIndustrys();

    /**
     * @Description: 分页查询情报系统行业关键词信息
     * @Author: lijian
     * @Date: 2019/3/21
     */
    PageResultDto<RiskIndustryWordDto> queryPage(ReqPageQuery param);


    RiskIndustryWordDto getById(Long id);

    /**
     * @Description: 获取所有行业关键词信息
     * @Author: lijian
     * @Date: 2019/3/21
     */
    List<RiskIndustryWordDto> getAllIndustryWord();

    /**
     * 根据父id查询关键词信息
     * @param parentIds
     * @return
     */
    List<RiskIndustryWordDto> getIndustryWordByParentIds(List<Long> parentIds);
}
