package cn.com.duiba.tuia.risk.center.api.remoteservice;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.risk.center.api.common.PageResultDto;
import cn.com.duiba.tuia.risk.center.api.dto.WaveAlarmConfigDto;
import cn.com.duiba.tuia.risk.center.api.dto.req.WaveAlarmConfigParam;

import java.util.List;

@AdvancedFeignClient
public interface RemoteWaveAlarmConfigService {

    Integer save(WaveAlarmConfigDto dto);

    Integer updateById(WaveAlarmConfigDto dto);

    /**
     * @Description: 根据报警状态查询规则波动报警配置信息
     * @Author: lijian
     * @Date: 2019/3/21
     */
    List<WaveAlarmConfigDto> getByAlarmStatus(Integer alarmStatus);

    /**
     * @Description: 分页查询规则波动报警配置信息
     * @Author: lijian
     * @Date: 2019/3/21
     */
    PageResultDto<WaveAlarmConfigDto> queryPage(WaveAlarmConfigParam param);

    /**
     * 规则异常监控定时任务
     */
    void ruleExceptionMonitorProcess();


}
