/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.tuia.risk.center.api.common;

import com.alibaba.fastjson.JSON;
import java.math.BigDecimal;

public class Probability
extends Number {
    private static final long serialVersionUID = 1L;
    private transient int hashCode = 0;
    private int numerator;
    private int denominator = 100;

    public Probability() {
    }

    public Probability(int numerator, int denominator) {
        this.checkArg(numerator, denominator);
        this.numerator = numerator;
        this.denominator = denominator;
    }

    public Probability(int persent) {
        this(persent, 100);
    }

    public int getNumerator() {
        return this.numerator;
    }

    public void setNumerator(int numerator) {
        this.numerator = numerator;
    }

    public int getDenominator() {
        return this.denominator;
    }

    public void setDenominator(int denominator) {
        this.denominator = denominator;
    }

    public static Probability getProbability(int numerator, int denominator) {
        return new Probability(numerator, denominator);
    }

    public static Probability getProbability(int percent) {
        return new Probability(percent, 100);
    }

    public static Probability getProbability(Integer percent) {
        if (percent == null) {
            return new Probability(0, 100);
        }
        return new Probability(percent, 100);
    }

    public static Probability getProbability(String value) {
        if (value == null) {
            throw new IllegalArgumentException("The string must not be null");
        }
        Double dvalue = Double.parseDouble(value.trim());
        if (dvalue < 0.0) {
            throw new IllegalArgumentException("Probability cannot be less than 0 ");
        }
        if (dvalue > 1.0) {
            throw new IllegalArgumentException("Probability cannot be greater than 1 ");
        }
        if (dvalue == 1.0) {
            return Probability.getProbability(100);
        }
        if (dvalue == 0.0) {
            return Probability.getProbability(0);
        }
        int length = value.length();
        int pl = Probability.getUselessPrefixLength(value);
        int sl = Probability.getUselessSuffixLength(value);
        int nl = length - pl - sl;
        char[] nc = new char[nl];
        for (int i = 0; i < nl; ++i) {
            nc[i] = value.charAt(pl++);
        }
        int denominator = 1;
        int dl = length - sl - 2;
        for (int i = 0; i < dl; ++i) {
            denominator *= 10;
        }
        return new Probability(Integer.valueOf(new String(nc)), denominator);
    }

    private static int getUselessPrefixLength(String value) {
        int i;
        for (i = 2; i < value.length() && value.charAt(i) == '0'; ++i) {
        }
        return i;
    }

    private static int getUselessSuffixLength(String value) {
        int i;
        for (i = value.length(); i > 0 && value.charAt(i - 1) == '0'; --i) {
        }
        return value.length() - i;
    }

    private void checkArg(int numerator, int denominator) {
        if (numerator < 0) {
            throw new IllegalArgumentException("Probability cannot be less than 0 ");
        }
        if (numerator > denominator) {
            throw new IllegalArgumentException("Probability cannot be greater than 1 ");
        }
        if (denominator == 0) {
            throw new IllegalArgumentException("Denominator cannot be 0 ");
        }
    }

    @Override
    public int intValue() {
        return this.numerator / this.denominator;
    }

    @Override
    public long longValue() {
        return (long)this.numerator / (long)this.denominator;
    }

    @Override
    public float floatValue() {
        return (float)this.numerator / (float)this.denominator;
    }

    @Override
    public double doubleValue() {
        return (double)this.numerator / (double)this.denominator;
    }

    public int intPercentValue() {
        return this.numerator * 100 / this.denominator;
    }

    public String stringValue() {
        return Double.toString(this.doubleValue());
    }

    public String stringValue(int scale) {
        return BigDecimal.valueOf(this.doubleValue()).setScale(scale, 4).toString();
    }

    public String stringPercentValue() {
        return Double.toString((double)(this.numerator * 100) / (double)this.denominator);
    }

    public String stringPercentValue(int scale) {
        return BigDecimal.valueOf((double)(this.numerator * 100) / (double)this.denominator).setScale(scale, 4).toString();
    }

    public String toPercentString() {
        return this.stringPercentValue(2) + "%";
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof Probability)) {
            return false;
        }
        Probability other = (Probability)obj;
        return other.getDenominator() * this.numerator == this.denominator * other.getNumerator();
    }

    public int hashCode() {
        if (this.hashCode == 0) {
            this.hashCode = 37 * (629 + this.getNumerator()) + this.getDenominator();
        }
        return this.hashCode;
    }

    public String toString() {
        return JSON.toJSONString((Object)this);
    }
}

