package cn.com.duiba.tuia.risk.center.api.dto;

import java.io.Serializable;
import java.util.Date;
import java.util.List;

/**
 * 违规处罚积分日志表
 */
public class AuditPunishRecordDto implements Serializable {

    private static final long serialVersionUID = 1L;

    /**
     * 主键
     */
    private Long id;

    /**
     * 处罚积分累计季度：如2021-Q1
     */
    private String tbQuarter;

    /**
     * 广告计划id
     */
    private Long advertId;

    /**
     * 广告名称
     */
    private String advertName;

    /**
     * 落地页链接
     */
    private String promoteUrl;

    /**
     * 类型 0-落地页返回拦截 1-落地页篡改
     */
    private Integer taskType;

    /**
     * 敏感词
     */
    private String violationWords;

    /**
     * url类型:0-落地页;1-二次跳转页面;2-配置落地页;3-ABTest落地页;4-素材绑定落地页;5-新媒体落地页
     */
    private Integer urlType;

    /**
     * 落地页ID
     */
    private Long landPageId;

    /**
     * 进审时间
     */
    private Date enterCheckTime;

    /**
     * 审核时间
     */
    private Date reviewTime;

    /**
     * 审核状态 0-拒绝，1-通过
     */
    private Integer reviewStatus;

    /**
     * 审核备注
     */
    private String reviewReason;

    /**
     * 业务场景
     */
    private String sceneName;

    /**
     * 等级,1:一级,2:二级,3:三级
     */
    private Integer gradeType;

    /**
     * 处罚描述
     */
    private String tbDescribe;

    /**
     * 处罚分
     */
    private Integer punishScore;

    /**
     * 季度累计处罚分
     */
    private Integer totalScore;

    /**
     * 广告主id
     */
    private Long accountId;

    /**
     * 广告主
     */
    private String advertMaster;

    /**
     * 代理商
     */
    private String agentName;

    /**
     * AE：该广告计划对应的AE，多个AE之间用顿号隔开
     */
    private String aeName;

    /**
     * 销售：该广告计划对应的销售，多个销售之间用顿号隔开
     */
    private String saleName;

    /**
     * 审核人
     */
    private String tbReviewer;

    /**
     * 申诉状态：0-未申诉、1-申诉成功、2-申诉失败
     */
    private Integer appealStatus;

    /**
     * 视频证明url
     */
    private String videoUrl;

    /**
     * 创建时间
     */
    private Date gmtCreate;

    /**
     * 修改时间
     */
    private Date gmtModified;

    /**
     * 审核图片列表
     */
    private List<String> imgUrls;


    public void setId(Long id) {
        this.id = id;
    }

    public Long getId() {
        return id;
    }

    public String getTbQuarter() {
        return tbQuarter;
    }

    public void setTbQuarter(String tbQuarter) {
        this.tbQuarter = tbQuarter;
    }

    public void setAdvertId(Long advertId) {
        this.advertId = advertId;
    }

    public Long getAdvertId() {
        return advertId;
    }

    public void setAdvertName(String advertName) {
        this.advertName = advertName;
    }

    public String getAdvertName() {
        return advertName;
    }

    public void setPromoteUrl(String promoteUrl) {
        this.promoteUrl = promoteUrl;
    }

    public String getPromoteUrl() {
        return promoteUrl;
    }

    public Date getEnterCheckTime() {
        return enterCheckTime;
    }

    public void setEnterCheckTime(Date enterCheckTime) {
        this.enterCheckTime = enterCheckTime;
    }

    public void setReviewTime(Date reviewTime) {
        this.reviewTime = reviewTime;
    }

    public Date getReviewTime() {
        return reviewTime;
    }

    public void setReviewStatus(Integer reviewStatus) {
        this.reviewStatus = reviewStatus;
    }

    public Integer getReviewStatus() {
        return reviewStatus;
    }

    public void setReviewReason(String reviewReason) {
        this.reviewReason = reviewReason;
    }

    public String getReviewReason() {
        return reviewReason;
    }

    public void setSceneName(String sceneName) {
        this.sceneName = sceneName;
    }

    public String getSceneName() {
        return sceneName;
    }

    public void setGradeType(Integer gradeType) {
        this.gradeType = gradeType;
    }

    public Integer getGradeType() {
        return gradeType;
    }

    public void setTbDescribe(String tbDescribe) {
        this.tbDescribe = tbDescribe;
    }

    public String getTbDescribe() {
        return tbDescribe;
    }

    public void setPunishScore(Integer punishScore) {
        this.punishScore = punishScore;
    }

    public Integer getPunishScore() {
        return punishScore;
    }

    public void setAccountId(Long accountId) {
        this.accountId = accountId;
    }

    public Long getAccountId() {
        return accountId;
    }

    public void setAdvertMaster(String advertMaster) {
        this.advertMaster = advertMaster;
    }

    public String getAdvertMaster() {
        return advertMaster;
    }

    public String getAgentName() {
        return agentName;
    }

    public void setAgentName(String agentName) {
        this.agentName = agentName;
    }

    public void setAeName(String aeName) {
        this.aeName = aeName;
    }

    public String getAeName() {
        return aeName;
    }

    public void setSaleName(String saleName) {
        this.saleName = saleName;
    }

    public String getSaleName() {
        return saleName;
    }

    public void setTbReviewer(String tbReviewer) {
        this.tbReviewer = tbReviewer;
    }

    public String getTbReviewer() {
        return tbReviewer;
    }

    public void setAppealStatus(Integer appealStatus) {
        this.appealStatus = appealStatus;
    }

    public Integer getAppealStatus() {
        return appealStatus;
    }

    public void setVideoUrl(String videoUrl) {
        this.videoUrl = videoUrl;
    }

    public String getVideoUrl() {
        return videoUrl;
    }

    public void setGmtCreate(Date gmtCreate) {
        this.gmtCreate = gmtCreate;
    }

    public Date getGmtCreate() {
        return gmtCreate;
    }

    public void setGmtModified(Date gmtModified) {
        this.gmtModified = gmtModified;
    }

    public Date getGmtModified() {
        return gmtModified;
    }

    public Integer getTotalScore() {
        return totalScore;
    }

    public void setTotalScore(Integer totalScore) {
        this.totalScore = totalScore;
    }

    public List<String> getImgUrls() {
        return imgUrls;
    }

    public void setImgUrls(List<String> imgUrls) {
        this.imgUrls = imgUrls;
    }

    public Integer getTaskType() {
        return taskType;
    }

    public void setTaskType(Integer taskType) {
        this.taskType = taskType;
    }

    public String getViolationWords() {
        return violationWords;
    }

    public void setViolationWords(String violationWords) {
        this.violationWords = violationWords;
    }

    public Integer getUrlType() {
        return urlType;
    }

    public void setUrlType(Integer urlType) {
        this.urlType = urlType;
    }

    public Long getLandPageId() {
        return landPageId;
    }

    public void setLandPageId(Long landPageId) {
        this.landPageId = landPageId;
    }
}

