package cn.com.duiba.tuia.risk.center.api.dto.req.domain;

import lombok.Data;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.io.Serializable;

/**
 * @author lijicong
 * @since 2021-03-25
 */
@Data
public class DomainNotifyDTO implements Serializable {
    private static final long serialVersionUID = 1L;

    /** 返回码 {@link cn.com.duiba.tuia.risk.center.api.enums.DomainNotifyCodeEnum} */
    @NotNull(message = "返回码不能为null")
    private Integer code;
    /** 内容 */
    private String msg;
    /** 域名 */
    @NotBlank(message = "域名不能为空")
    private String domainName;
    /** 重试次数（异常重试3次） */
    private Integer retries;

}
