package cn.com.duiba.tuia.risk.center.api.dto;

import com.univocity.parsers.annotations.Convert;
import com.univocity.parsers.annotations.Parsed;
import com.univocity.parsers.conversions.DateConversion;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;

/**
* 作弊识别明细表
*/
@ApiModel
public class CheatIdentDetailDto implements Serializable {

    private static final long serialVersionUID = -1578793360015486897L;

    /**
    * 主键
    */
    @ApiModelProperty("主键")
    private Long id;

    /**
    * 日期
    */
    @ApiModelProperty("日期")
    @Parsed(field = "日期", defaultNullWrite = "")
    @Convert(conversionClass = DateConversion.class, args = "yyyy-MM-dd")
    private Date curDate;

    /**
    * 大盘总消耗(分)
    */
    @ApiModelProperty("大盘总消耗")
    @Parsed(field = "大盘总消耗", defaultNullWrite = "")
    private Long totalConsume;

    /**
    * 总作弊消耗(分)
     * 总作弊识别消耗 = A类量化作弊消耗 + C类离线用户作弊消耗 + C类实时拦截作弊消耗
    */
    @ApiModelProperty("总作弊识别消耗")
    @Parsed(field = "总作弊识别消耗", defaultNullWrite = "")
    private Long cheatConsume;

    /**
    * 作弊识别率：总作弊消耗 / 大盘总消耗
    */
    @ApiModelProperty("作弊消耗占比")
    @Parsed(field = "作弊消耗占比", defaultNullWrite = "")
    private Double cheatIdentRate;

    /**
    * 风险广告位总消耗
    */
    @ApiModelProperty("风险广告位总消耗")
    @Parsed(field = "风险广告位总消耗", defaultNullWrite = "")
    private Long slotConsume;

    /**
    * 风险广告位作弊消耗
    */
    @ApiModelProperty("风险广告位作弊消耗")
    @Parsed(field = "风险广告位作弊消耗", defaultNullWrite = "")
    private Long slotCheatConsume;

    /**
    * 风险广告位作弊识别率：风险媒体作弊消耗/总作弊消耗
    */
    @ApiModelProperty("风险广告位作弊识别率")
    @Parsed(field = "风险广告位作弊识别率", defaultNullWrite = "")
    private Double slotCheatRate;

    /**
    * A类规则作弊消耗
    */
    @ApiModelProperty("A类规则作弊消耗")
    @Parsed(field = "A类规则作弊消耗", defaultNullWrite = "")
    private Long acheatConsume;

    /**
    * C类实际作弊消耗
    */
    @ApiModelProperty("C类离线识别发券")
    @Parsed(field = "C类离线识别发券", defaultNullWrite = "")
    private Long ccheatConsume;

    /**
    * C类拦截作弊消耗
    */
    @ApiModelProperty("C类实时拦截作弊消耗")
    @Parsed(field = "C类实时拦截作弊消耗", defaultNullWrite = "")
    private Long cstopcheatConsume;

    /**
     * A类规则作弊消耗占比：A类规则作弊消耗/总作弊消耗
     */
    private Double acheatRate;

    /**
     * C类实际作弊消耗占比：C类实际作弊消耗/总作弊消耗
     */
    private Double ccheatRate;

    /**
     * C类拦截作弊消耗占比：C类拦截作弊消耗/总作弊消耗
     */
    private Double cstopcheatRate;


    @ApiModelProperty("创建时间")
    private Date gmtCreate;

    @ApiModelProperty("更新时间")
    private Date gmtModified;

    @ApiModelProperty("大盘ARPU")
    @Parsed(field = "大盘ARPU", defaultNullWrite = "")
    private BigDecimal totalArpu;
    @ApiModelProperty("C类作弊流量ARPU")
    @Parsed(field = "C类作弊流量ARPU", defaultNullWrite = "")
    private BigDecimal cCheatArpu;
    @ApiModelProperty("A类作弊流量ARPU")
    @Parsed(field = "A类作弊流量ARPU", defaultNullWrite = "")
    private BigDecimal aCheatArpu;

    @ApiModelProperty("C类离线识别发券")
    @Parsed(field = "C类离线识别发券", defaultNullWrite = "")
    private Long cCheatLaunch;

    @ApiModelProperty("C类实时拦截作弊发券")
    @Parsed(field = "C类实时拦截作弊发券", defaultNullWrite = "")
    private Long cCheatInterceptLaunch;

    /**
     * A类离线识别发券 = ∑ 广告位（A类规则量化比例 * 广告位当日付费发券PV）
     */
    @ApiModelProperty("A类离线识别发券")
    @Parsed(field = "A类离线识别发券", defaultNullWrite = "")
    private Long aCheatLaunch;
    /**
     *总作弊识别发券 = A类离线发券 + C类离线发券 + C类实时拦截发券
     */
    @ApiModelProperty("总作弊识别发券")
    @Parsed(field = "总作弊识别发券", defaultNullWrite = "")
    private Long totalCheatLaunch;

    @ApiModelProperty("总发券")
    @Parsed(field = "总发券", defaultNullWrite = "")
    private Long totalLaunch;

    /**
     *规则引擎识别发券 = 规则实时命中日志
     */
    @ApiModelProperty("规则引擎识别发券")
    @Parsed(field = "规则引擎识别发券", defaultNullWrite = "")
    private Long realRuleLaunch;
    /**
     *规则引擎识别消耗 = ∑广告位下实时引擎拦截发券计费点击PV  * （当日大盘总消耗 / 当日非风控发券总计费点击PV）
     */
    @ApiModelProperty("规则引擎识别消耗")
    @Parsed(field = "规则引擎识别消耗", defaultNullWrite = "")
    private Long realRuleConsume;

    /**
     *黑名单拦截发券 = 黑名单命中数据
     */
    @ApiModelProperty("黑名单拦截发券")
    @Parsed(field = "黑名单拦截发券", defaultNullWrite = "")
    private Long blackLaunch;
    /**
     *黑名单拦截消耗 =  ∑广告位下C类黑名单拦截发券计费点击PV  * （当日大盘总消耗 / 当日非风控发券总计费点击PV）
     */
    @ApiModelProperty("黑名单拦截消耗")
    @Parsed(field = "黑名单拦截消耗", defaultNullWrite = "")
    private Long blackConsume;

    @ApiModelProperty("A类离线发券占比")
    @Parsed(field = "A类离线发券占比", defaultNullWrite = "")
    private BigDecimal aLaunchRate;

    /**
     * A类规则作弊消耗占比：A类规则作弊消耗/总作弊消耗
     */
    @ApiModelProperty("A类离线消耗占比")
    @Parsed(field = "A类离线消耗占比", defaultNullWrite = "")
    private BigDecimal aConsumeRate;


    @ApiModelProperty("C类离线发券占比")
    @Parsed(field = "C类离线发券占比", defaultNullWrite = "")
    private BigDecimal cOffLaunchRate;


    @ApiModelProperty("C类离线消耗占比")
    @Parsed(field = "C类离线消耗占比", defaultNullWrite = "")
    private BigDecimal cOffConsumeRate;

    @ApiModelProperty("C类实时发券占比")
    @Parsed(field = "C类实时发券占比", defaultNullWrite = "")
    private BigDecimal cOnLaunchRate;


    @ApiModelProperty("C类实时消耗占比")
    @Parsed(field = "C类实时消耗占比", defaultNullWrite = "")
    private BigDecimal cOnConsumeRate;

    /**
     *规则引擎识别发券占比 = 规则引擎识别发券 / C规则拦截作弊发券
     */
    @ApiModelProperty("规则引擎识别发券占比")
    @Parsed(field = "规则引擎识别发券占比", defaultNullWrite = "")
    private BigDecimal realRuleLaunchRate;

    /**
     *规则引擎识别消耗占比 = 规则引擎识别消耗 / C规则识别消耗
     */
    @ApiModelProperty("规则引擎识别发券占比")
    @Parsed(field = "规则引擎识别发券占比", defaultNullWrite = "")
    private BigDecimal realRuleConsumeRate;

    /**
     *黑名单拦截发券占比 = 黑名单拦截发券 / 实时风控发券
     */
    @ApiModelProperty("黑名单拦截发券占比")
    @Parsed(field = "黑名单拦截发券占比", defaultNullWrite = "")
    private BigDecimal blackLaunchRate;
    /**
     *黑名单拦截消耗占比 = 黑名单拦截消耗 / 实时风控消耗
     */
    @ApiModelProperty("黑名单拦截消耗占比")
    @Parsed(field = "黑名单拦截消耗占比", defaultNullWrite = "")
    private BigDecimal blackConsumeRate;


    @ApiModelProperty("作弊发券占比")
    @Parsed(field = "作弊发券占比", defaultNullWrite = "")
    private BigDecimal cheatLaunchRate;


    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Date getCurDate() {
        return curDate;
    }

    public void setCurDate(Date curDate) {
        this.curDate = curDate;
    }

    public Long getTotalConsume() {
        return totalConsume;
    }

    public void setTotalConsume(Long totalConsume) {
        this.totalConsume = totalConsume;
    }

    public Long getCheatConsume() {
        return cheatConsume;
    }

    public void setCheatConsume(Long cheatConsume) {
        this.cheatConsume = cheatConsume;
    }

    public Double getCheatIdentRate() {
        return cheatIdentRate;
    }

    public void setCheatIdentRate(Double cheatIdentRate) {
        this.cheatIdentRate = cheatIdentRate;
    }

    public Long getSlotConsume() {
        return slotConsume;
    }

    public void setSlotConsume(Long slotConsume) {
        this.slotConsume = slotConsume;
    }

    public Long getSlotCheatConsume() {
        return slotCheatConsume;
    }

    public void setSlotCheatConsume(Long slotCheatConsume) {
        this.slotCheatConsume = slotCheatConsume;
    }

    public Double getSlotCheatRate() {
        return slotCheatRate;
    }

    public void setSlotCheatRate(Double slotCheatRate) {
        this.slotCheatRate = slotCheatRate;
    }

    public Long getAcheatConsume() {
        return acheatConsume;
    }

    public void setAcheatConsume(Long acheatConsume) {
        this.acheatConsume = acheatConsume;
    }

    public Long getCcheatConsume() {
        return ccheatConsume;
    }

    public void setCcheatConsume(Long ccheatConsume) {
        this.ccheatConsume = ccheatConsume;
    }

    public Long getCstopcheatConsume() {
        return cstopcheatConsume;
    }

    public void setCstopcheatConsume(Long cstopcheatConsume) {
        this.cstopcheatConsume = cstopcheatConsume;
    }

    public Date getGmtCreate() {
        return gmtCreate;
    }

    public void setGmtCreate(Date gmtCreate) {
        this.gmtCreate = gmtCreate;
    }

    public Date getGmtModified() {
        return gmtModified;
    }

    public void setGmtModified(Date gmtModified) {
        this.gmtModified = gmtModified;
    }

    public BigDecimal getTotalArpu() {
        return totalArpu;
    }

    public void setTotalArpu(BigDecimal totalArpu) {
        this.totalArpu = totalArpu;
    }

    public BigDecimal getcCheatArpu() {
        return cCheatArpu;
    }

    public void setcCheatArpu(BigDecimal cCheatArpu) {
        this.cCheatArpu = cCheatArpu;
    }

    public BigDecimal getaCheatArpu() {
        return aCheatArpu;
    }

    public void setaCheatArpu(BigDecimal aCheatArpu) {
        this.aCheatArpu = aCheatArpu;
    }

    public Long getcCheatLaunch() {
        return cCheatLaunch;
    }

    public void setcCheatLaunch(Long cCheatLaunch) {
        this.cCheatLaunch = cCheatLaunch;
    }

    public Long getcCheatInterceptLaunch() {
        return cCheatInterceptLaunch;
    }

    public void setcCheatInterceptLaunch(Long cCheatInterceptLaunch) {
        this.cCheatInterceptLaunch = cCheatInterceptLaunch;
    }

    public Long getaCheatLaunch() {
        return aCheatLaunch;
    }

    public void setaCheatLaunch(Long aCheatLaunch) {
        this.aCheatLaunch = aCheatLaunch;
    }

    public Long getTotalCheatLaunch() {
        return totalCheatLaunch;
    }

    public void setTotalCheatLaunch(Long totalCheatLaunch) {
        this.totalCheatLaunch = totalCheatLaunch;
    }

    public Long getRealRuleLaunch() {
        return realRuleLaunch;
    }

    public void setRealRuleLaunch(Long realRuleLaunch) {
        this.realRuleLaunch = realRuleLaunch;
    }

    public Long getRealRuleConsume() {
        return realRuleConsume;
    }

    public void setRealRuleConsume(Long realRuleConsume) {
        this.realRuleConsume = realRuleConsume;
    }

    public BigDecimal getRealRuleLaunchRate() {
        return realRuleLaunchRate;
    }

    public void setRealRuleLaunchRate(BigDecimal realRuleLaunchRate) {
        this.realRuleLaunchRate = realRuleLaunchRate;
    }

    public BigDecimal getRealRuleConsumeRate() {
        return realRuleConsumeRate;
    }

    public void setRealRuleConsumeRate(BigDecimal realRuleConsumeRate) {
        this.realRuleConsumeRate = realRuleConsumeRate;
    }

    public Long getBlackLaunch() {
        return blackLaunch;
    }

    public void setBlackLaunch(Long blackLaunch) {
        this.blackLaunch = blackLaunch;
    }

    public Long getBlackConsume() {
        return blackConsume;
    }

    public void setBlackConsume(Long blackConsume) {
        this.blackConsume = blackConsume;
    }

    public BigDecimal getBlackLaunchRate() {
        return blackLaunchRate;
    }

    public void setBlackLaunchRate(BigDecimal blackLaunchRate) {
        this.blackLaunchRate = blackLaunchRate;
    }

    public BigDecimal getBlackConsumeRate() {
        return blackConsumeRate;
    }

    public void setBlackConsumeRate(BigDecimal blackConsumeRate) {
        this.blackConsumeRate = blackConsumeRate;
    }

    public BigDecimal getaLaunchRate() {
        return aLaunchRate;
    }

    public void setaLaunchRate(BigDecimal aLaunchRate) {
        this.aLaunchRate = aLaunchRate;
    }

    public BigDecimal getaConsumeRate() {
        return aConsumeRate;
    }

    public void setaConsumeRate(BigDecimal aConsumeRate) {
        this.aConsumeRate = aConsumeRate;
    }

    public BigDecimal getcOffLaunchRate() {
        return cOffLaunchRate;
    }

    public void setcOffLaunchRate(BigDecimal cOffLaunchRate) {
        this.cOffLaunchRate = cOffLaunchRate;
    }

    public BigDecimal getcOffConsumeRate() {
        return cOffConsumeRate;
    }

    public void setcOffConsumeRate(BigDecimal cOffConsumeRate) {
        this.cOffConsumeRate = cOffConsumeRate;
    }

    public BigDecimal getcOnLaunchRate() {
        return cOnLaunchRate;
    }

    public void setcOnLaunchRate(BigDecimal cOnLaunchRate) {
        this.cOnLaunchRate = cOnLaunchRate;
    }

    public BigDecimal getcOnConsumeRate() {
        return cOnConsumeRate;
    }

    public void setcOnConsumeRate(BigDecimal cOnConsumeRate) {
        this.cOnConsumeRate = cOnConsumeRate;
    }

    public Double getAcheatRate() {
        return acheatRate;
    }

    public void setAcheatRate(Double acheatRate) {
        this.acheatRate = acheatRate;
    }

    public Double getCcheatRate() {
        return ccheatRate;
    }

    public void setCcheatRate(Double ccheatRate) {
        this.ccheatRate = ccheatRate;
    }

    public Double getCstopcheatRate() {
        return cstopcheatRate;
    }

    public void setCstopcheatRate(Double cstopcheatRate) {
        this.cstopcheatRate = cstopcheatRate;
    }

    public Long getTotalLaunch() {
        return totalLaunch;
    }

    public void setTotalLaunch(Long totalLaunch) {
        this.totalLaunch = totalLaunch;
    }

    public BigDecimal getCheatLaunchRate() {
        return cheatLaunchRate;
    }

    public void setCheatLaunchRate(BigDecimal cheatLaunchRate) {
        this.cheatLaunchRate = cheatLaunchRate;
    }
}

