package cn.com.duiba.tuia.risk.center.api.dto;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import org.hibernate.validator.constraints.Range;

import java.io.Serializable;
import java.util.Date;

/**
 * 竞品巡查域名管理表
 */
@ApiModel
public class CompeteDomainPatrolDto implements Serializable {

    private static final long serialVersionUID = 8334795148193478241L;
    //最近一次该条数据执行巡查的状态进行中/未开始
    public static final int LASTEXECUTESTATEING=0;
    //最近一次该条数据执行巡查的状态结束
    public static final int LASTEXECUTESTATEEND=1;

    @ApiModelProperty("主键")
    private Long id;

    @ApiModelProperty("竞品URL")
    private String competeUrl;

    @ApiModelProperty("竞品编号")
    private String competeCode;

    @ApiModelProperty("竞品名称")
    private String competeName;

    @ApiModelProperty("媒体名称")
    private String mediaName;

    @ApiModelProperty("巡查日志数量")
    private Integer recordCount;

    @ApiModelProperty("过期日期")
    private Date expiredDate;

    @ApiModelProperty("巡查时间:小时，用英文逗号隔开")
    private String patrolHour;

    @ApiModelProperty("最后修改人")
    private String modifier;

    @ApiModelProperty("记录创建时间")
    private Date gmtCreate;

    @ApiModelProperty("记录修改时间")
    private Date gmtModified;
    @ApiModelProperty("巡查周期（分）")
    @Range(min = 5,max = 200)
    private Integer patrolPeriod;
    @ApiModelProperty("最近一次该条数据执行巡查的时间")
    private Date lastExecuteTime;
    @ApiModelProperty("最近一次该条数据执行巡查的状态,0代表执行中或者未执行，1代表执行完毕")
    private Integer lastExecuteState;

    public Integer getPatrolPeriod() {
        return patrolPeriod;
    }

    public void setPatrolPeriod(Integer patrolPeriod) {
        this.patrolPeriod = patrolPeriod;
    }

    public Date getLastExecuteTime() {
        return lastExecuteTime;
    }

    public void setLastExecuteTime(Date lastExecuteTime) {
        this.lastExecuteTime = lastExecuteTime;
    }

    public Integer getLastExecuteState() {
        return lastExecuteState;
    }

    public void setLastExecuteState(Integer lastExecuteState) {
        this.lastExecuteState = lastExecuteState;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Long getId() {
        return id;
    }

    public void setCompeteUrl(String competeUrl) {
        this.competeUrl = competeUrl;
    }

    public String getCompeteUrl() {
        return competeUrl;
    }

    public void setCompeteCode(String competeCode) {
        this.competeCode = competeCode;
    }

    public String getCompeteCode() {
        return competeCode;
    }

    public void setCompeteName(String competeName) {
        this.competeName = competeName;
    }

    public String getCompeteName() {
        return competeName;
    }

    public void setMediaName(String mediaName) {
        this.mediaName = mediaName;
    }

    public String getMediaName() {
        return mediaName;
    }

    public void setRecordCount(Integer recordCount) {
        this.recordCount = recordCount;
    }

    public Integer getRecordCount() {
        return recordCount;
    }

    public void setExpiredDate(Date expiredDate) {
        this.expiredDate = expiredDate;
    }

    public Date getExpiredDate() {
        return expiredDate;
    }

    public void setPatrolHour(String patrolHour) {
        this.patrolHour = patrolHour;
    }

    public String getPatrolHour() {
        return patrolHour;
    }

    public void setModifier(String modifier) {
        this.modifier = modifier;
    }

    public String getModifier() {
        return modifier;
    }

    public void setGmtCreate(Date gmtCreate) {
        this.gmtCreate = gmtCreate;
    }

    public Date getGmtCreate() {
        return gmtCreate;
    }

    public void setGmtModified(Date gmtModified) {
        this.gmtModified = gmtModified;
    }

    public Date getGmtModified() {
        return gmtModified;
    }

}

