package cn.com.duiba.tuia.risk.center.api.dto;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.io.Serializable;
import java.util.Date;
import java.util.List;
import java.util.Set;

/**
* 媒体黑名单信息表
*/
@ApiModel
public class MediaBlackDto implements Serializable {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty("主键ID")
    private Long id;

    @ApiModelProperty("媒体用户ID")
    private Long mediaId;

    @ApiModelProperty("公司名称")
    private String companyName;

    @ApiModelProperty("账号类别:  1-直客 2-代理 3代理商")
    private Integer accountType;

    @ApiModelProperty("代理商ID")
    private Long parentMediaId;

    @ApiModelProperty("黑名单场景:  1-媒体作弊 2-竞品公司 3-内部廉政")
    private Integer blackScene;

    @ApiModelProperty("黑名单等级:  1-问题账户 2-一级黑名单 3-二级黑名单 4-三级黑名单")
    private Integer blackGrade;

    @ApiModelProperty("备注")
    private String remark;

    @ApiModelProperty("创建人")
    private String creator;

    @ApiModelProperty("创建时间")
    private Date gmtCreate;

    @ApiModelProperty("修改时间")
    private Date gmtModified;

    @ApiModelProperty("关联黑名单媒体账户ID列表")
    private List<Long> relateBlackMediaIds;


    public void setId(Long id) {
        this.id = id;
    }

    public Long getId() {
        return id;
    }

    public void setMediaId(Long mediaId) {
        this.mediaId = mediaId;
    }

    public Long getMediaId() {
        return mediaId;
    }

    public void setCompanyName(String companyName) {
        this.companyName = companyName;
    }

    public String getCompanyName() {
        return companyName;
    }

    public void setAccountType(Integer accountType) {
        this.accountType = accountType;
    }

    public Integer getAccountType() {
        return accountType;
    }

    public void setParentMediaId(Long parentMediaId) {
        this.parentMediaId = parentMediaId;
    }

    public Long getParentMediaId() {
        return parentMediaId;
    }

    public void setBlackScene(Integer blackScene) {
        this.blackScene = blackScene;
    }

    public Integer getBlackScene() {
        return blackScene;
    }

    public void setBlackGrade(Integer blackGrade) {
        this.blackGrade = blackGrade;
    }

    public Integer getBlackGrade() {
        return blackGrade;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }

    public String getRemark() {
        return remark;
    }

    public void setCreator(String creator) {
        this.creator = creator;
    }

    public String getCreator() {
        return creator;
    }

    public void setGmtCreate(Date gmtCreate) {
        this.gmtCreate = gmtCreate;
    }

    public Date getGmtCreate() {
        return gmtCreate;
    }

    public void setGmtModified(Date gmtModified) {
        this.gmtModified = gmtModified;
    }

    public Date getGmtModified() {
        return gmtModified;
    }

    public List<Long> getRelateBlackMediaIds() {
        return relateBlackMediaIds;
    }

    public void setRelateBlackMediaIds(List<Long> relateBlackMediaIds) {
        this.relateBlackMediaIds = relateBlackMediaIds;
    }

}

