package cn.com.duiba.tuia.risk.center.api.dto;

import io.swagger.annotations.ApiModelProperty;

import java.io.Serializable;
import java.util.Date;

/**
* 媒体账户多维度关联表
*/
public class MediaRelateDto implements Serializable {

    private static final long serialVersionUID = 1L;

    /**
    * 主键ID
    */
    private Long id;

    /**
    * 媒体用户ID
    */
    private Long mediaId;

    /**
    * 公司名称
    */
    private String companyName;

    /**
    * 联系电话
    */
    private String linkmanPhone;

    /**
    * 邮箱账号
    */
    private String email;

    /**
    * 账号类别:  1-直客 2-代理 3代理商
    */
    private Integer accountType;

    /**
     * 代理商ID
     */
    private Long parentMediaId;

    /**
    * 公司关联账号id列表,多个英文逗号隔开
    */
    private String companyRelate;

    /**
    * 手机号关联账号id列表,多个英文逗号隔开
    */
    private String phoneRelate;

    /**
    * 邮箱关联账号id列表,多个英文逗号隔开
    */
    private String emailRelate;

    /**
     * ip关联账号id列表,多个英文逗号隔开
     */
    private String ipRelate;

    /**
    * 近30天总消耗
    */
    private Long thirtyConsume;

    /**
    * 近30天媒体应得收入
    */
    private Long thirtyIncome;

    /**
    * 近30天现金总消耗
    */
    private Long thirtyCashConsume;

    /**
     * 现金分成比例
     */
    private Double cashShareRate;

    /**
    * 媒介运营
    */
    private String mediumOperate;

    /**
    * 媒体运营
    */
    private String mediaOperate;

    /**
    * 创建时间
    */
    private Date gmtCreate;

    /**
    * 修改时间
    */
    private Date gmtModified;

    /**
     * 是否关联黑名单账户（1:是 0：否）
     */
    private Integer blacked;

    @ApiModelProperty("黑名单等级:  1-问题账户 2-一级黑名单 3-二级黑名单 4-三级黑名单")
    private Integer blackGrade;

    /**
     * 关联维度
     */
    private String relateTypeDesc;


    public void setId(Long id) {
        this.id = id;
    }

    public Long getId() {
        return id;
    }

    public void setMediaId(Long mediaId) {
        this.mediaId = mediaId;
    }

    public Long getMediaId() {
        return mediaId;
    }

    public void setCompanyName(String companyName) {
        this.companyName = companyName;
    }

    public String getCompanyName() {
        return companyName;
    }

    public void setLinkmanPhone(String linkmanPhone) {
        this.linkmanPhone = linkmanPhone;
    }

    public String getLinkmanPhone() {
        return linkmanPhone;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public String getEmail() {
        return email;
    }

    public void setAccountType(Integer accountType) {
        this.accountType = accountType;
    }

    public Integer getAccountType() {
        return accountType;
    }

    public void setCompanyRelate(String companyRelate) {
        this.companyRelate = companyRelate;
    }

    public String getCompanyRelate() {
        return companyRelate;
    }

    public void setPhoneRelate(String phoneRelate) {
        this.phoneRelate = phoneRelate;
    }

    public String getPhoneRelate() {
        return phoneRelate;
    }

    public void setEmailRelate(String emailRelate) {
        this.emailRelate = emailRelate;
    }

    public String getEmailRelate() {
        return emailRelate;
    }

    public void setThirtyConsume(Long thirtyConsume) {
        this.thirtyConsume = thirtyConsume;
    }

    public Long getThirtyConsume() {
        return thirtyConsume;
    }

    public void setThirtyIncome(Long thirtyIncome) {
        this.thirtyIncome = thirtyIncome;
    }

    public Long getThirtyIncome() {
        return thirtyIncome;
    }

    public void setThirtyCashConsume(Long thirtyCashConsume) {
        this.thirtyCashConsume = thirtyCashConsume;
    }

    public Long getThirtyCashConsume() {
        return thirtyCashConsume;
    }

    public void setMediumOperate(String mediumOperate) {
        this.mediumOperate = mediumOperate;
    }

    public String getMediumOperate() {
        return mediumOperate;
    }

    public void setMediaOperate(String mediaOperate) {
        this.mediaOperate = mediaOperate;
    }

    public String getMediaOperate() {
        return mediaOperate;
    }

    public void setGmtCreate(Date gmtCreate) {
        this.gmtCreate = gmtCreate;
    }

    public Date getGmtCreate() {
        return gmtCreate;
    }

    public void setGmtModified(Date gmtModified) {
        this.gmtModified = gmtModified;
    }

    public Date getGmtModified() {
        return gmtModified;
    }

    public Double getCashShareRate() {
        return cashShareRate;
    }

    public void setCashShareRate(Double cashShareRate) {
        this.cashShareRate = cashShareRate;
    }

    public Long getParentMediaId() {
        return parentMediaId;
    }

    public void setParentMediaId(Long parentMediaId) {
        this.parentMediaId = parentMediaId;
    }

    public String getIpRelate() {
        return ipRelate;
    }

    public void setIpRelate(String ipRelate) {
        this.ipRelate = ipRelate;
    }

    public Integer getBlacked() {
        return blacked;
    }

    public void setBlacked(Integer blacked) {
        this.blacked = blacked;
    }

    public Integer getBlackGrade() {
        return blackGrade;
    }

    public void setBlackGrade(Integer blackGrade) {
        this.blackGrade = blackGrade;
    }

    public String getRelateTypeDesc() {
        return relateTypeDesc;
    }

    public void setRelateTypeDesc(String relateTypeDesc) {
        this.relateTypeDesc = relateTypeDesc;
    }


}

