package cn.com.duiba.tuia.risk.center.api.dto;

import java.io.Serializable;
import java.util.Date;

/**
* 广告url延迟处罚表
*/
public class UrlDelayPunishDto implements Serializable {

    private static final long serialVersionUID = 1L;

    /**
    * 
    */
    private Long id;

    /**
     * 审核时间
     */
    private Date reviewTime;

    /**
     * 类型 0-落地页返回拦截 1-落地页篡改
     */
    private Integer taskType;

    /**
     * 处罚状态 1-已处罚，0-待处罚
     */
    private Integer punishStatus;

    /**
    * 广告计划id
    */
    private Long advertId;

    /**
    * 广告主id
    */
    private Long accountId;

    /**
    * url类型:0-落地页;1-二次跳转页面;2-配置落地页;3-ABTest落地页;4-素材绑定落地页;5-新媒体落地页
    */
    private Integer urlType;

    /**
    * 落地页ID
    */
    private Long landPageId;

    /**
    * 申诉状态：0-未申诉、1-申诉成功、2-申诉失败
    */
    private Integer appealStatus;

    /**
    * 记录创建时间
    */
    private Date gmtCreate;

    /**
    * 记录修改时间
    */
    private Date gmtModified;


    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Date getReviewTime() {
        return reviewTime;
    }

    public void setReviewTime(Date reviewTime) {
        this.reviewTime = reviewTime;
    }

    public Integer getTaskType() {
        return taskType;
    }

    public void setTaskType(Integer taskType) {
        this.taskType = taskType;
    }

    public Integer getPunishStatus() {
        return punishStatus;
    }

    public void setPunishStatus(Integer punishStatus) {
        this.punishStatus = punishStatus;
    }

    public Long getAdvertId() {
        return advertId;
    }

    public void setAdvertId(Long advertId) {
        this.advertId = advertId;
    }

    public Long getAccountId() {
        return accountId;
    }

    public void setAccountId(Long accountId) {
        this.accountId = accountId;
    }

    public Integer getUrlType() {
        return urlType;
    }

    public void setUrlType(Integer urlType) {
        this.urlType = urlType;
    }

    public Long getLandPageId() {
        return landPageId;
    }

    public void setLandPageId(Long landPageId) {
        this.landPageId = landPageId;
    }

    public Integer getAppealStatus() {
        return appealStatus;
    }

    public void setAppealStatus(Integer appealStatus) {
        this.appealStatus = appealStatus;
    }

    public Date getGmtCreate() {
        return gmtCreate;
    }

    public void setGmtCreate(Date gmtCreate) {
        this.gmtCreate = gmtCreate;
    }

    public Date getGmtModified() {
        return gmtModified;
    }

    public void setGmtModified(Date gmtModified) {
        this.gmtModified = gmtModified;
    }
}

