package cn.com.duiba.tuia.risk.center.api.dto;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.io.Serializable;
import java.math.BigDecimal;

/**
 * 规则波动报警信息
 */
@ApiModel
public class WaveAlarmRsp implements Serializable {

    private static final long serialVersionUID = 7733926456174690267L;

    @ApiModelProperty("规则ID")
    private String ruleId;

    @ApiModelProperty("规则名称")
    private String ruleName;

    @ApiModelProperty("规则类型，0-A类规则 1-C类规则-实时 2-C类规则离线")
    private Integer ruleType;

    @ApiModelProperty("波动率报警上限")
    private BigDecimal alarmUp;

    @ApiModelProperty("波动率报警下限")
    private BigDecimal alarmLow;

    @ApiModelProperty("规则识别率：规则识别的作弊消耗/大盘总消耗")
    private BigDecimal recognitionRate;

    @ApiModelProperty("近七日规则识别率：规则识别的作弊消耗/大盘总消耗")
    private BigDecimal sevenRecognitionRate;

    @ApiModelProperty("近七日有规则识别率的数量")
    private Integer sevenCount;

    @ApiModelProperty("规则波动率=（昨日规则识别率-7日规则识别率）/7日规则识别率")
    BigDecimal ruleWaveRate;

    public WaveAlarmRsp() {
        this.sevenCount = 0;
        this.sevenRecognitionRate = BigDecimal.ZERO;
        this.ruleWaveRate = BigDecimal.ZERO;
        this.recognitionRate= BigDecimal.ZERO;
    }

    public String getRuleId() {
        return ruleId;
    }

    public void setRuleId(String ruleId) {
        this.ruleId = ruleId;
    }

    public String getRuleName() {
        return ruleName;
    }

    public void setRuleName(String ruleName) {
        this.ruleName = ruleName;
    }

    public Integer getRuleType() {
        return ruleType;
    }

    public void setRuleType(Integer ruleType) {
        this.ruleType = ruleType;
    }

    public BigDecimal getAlarmUp() {
        return alarmUp;
    }

    public void setAlarmUp(BigDecimal alarmUp) {
        this.alarmUp = alarmUp;
    }

    public BigDecimal getAlarmLow() {
        return alarmLow;
    }

    public void setAlarmLow(BigDecimal alarmLow) {
        this.alarmLow = alarmLow;
    }

    public BigDecimal getRecognitionRate() {
        return recognitionRate;
    }

    public void setRecognitionRate(BigDecimal recognitionRate) {
        this.recognitionRate = recognitionRate;
    }

    public BigDecimal getSevenRecognitionRate() {
        return sevenRecognitionRate;
    }

    public void setSevenRecognitionRate(BigDecimal sevenRecognitionRate) {
        this.sevenRecognitionRate = sevenRecognitionRate;
    }

    public Integer getSevenCount() {
        return sevenCount;
    }

    public void setSevenCount(Integer sevenCount) {
        this.sevenCount = sevenCount;
    }

    public BigDecimal getRuleWaveRate() {
        return ruleWaveRate;
    }

    public void setRuleWaveRate(BigDecimal ruleWaveRate) {
        this.ruleWaveRate = ruleWaveRate;
    }

    //计算规则识别率：规则识别的作弊消耗/大盘总消耗
    public void calSevenRecognitionRate() {
        BigDecimal result=BigDecimal.ZERO;
        if(sevenCount>0){
            result=sevenRecognitionRate.divide(BigDecimal.valueOf(sevenCount),3, BigDecimal.ROUND_HALF_UP);
        }
        this.sevenRecognitionRate = result;
    }

    //计算规则波动率=（昨日规则识别率-7日规则识别率）/7日规则识别率
    public void calRuleWaveRate() {
        calSevenRecognitionRate();//7日规则识别率
        //规则波动率=（昨日规则识别率-7日规则识别率）/7日规则识别率
        BigDecimal waveRate=BigDecimal.ZERO;
        if(sevenRecognitionRate.compareTo(BigDecimal.ZERO)!=0){
            waveRate=recognitionRate
                    .subtract(sevenRecognitionRate)
                    .multiply(BigDecimal.valueOf(100))
                    .divide(sevenRecognitionRate,2, BigDecimal.ROUND_HALF_UP);
        }
        this.ruleWaveRate = waveRate;
    }
}

