package cn.com.duiba.tuia.risk.center.api.dto.req;

import java.io.Serializable;
import java.util.Date;
import java.util.List;

import javax.validation.Valid;
import javax.validation.constraints.NotNull;

import org.hibernate.validator.constraints.Length;
import org.hibernate.validator.constraints.NotEmpty;
import org.hibernate.validator.constraints.Range;

import cn.com.duiba.tuia.risk.center.api.constant.RuleAction;
import cn.com.duiba.tuia.risk.center.api.dto.EngineConditionDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

/**
* 规则表
*/
@Data
@ApiModel
public class EngineRuleBaseParam implements Serializable {

    private static final long serialVersionUID = 1L;

    /**
    * 策略id
    */
    @NotNull(message = "策略id不能为null")
    @ApiModelProperty("策略id")
    private Long strategyId;

    /**
    * 父规则id
    */
    @ApiModelProperty("父规则id")
    private Long parentRuleId;

    /**
    * 规则名字
    */
    @NotEmpty(message = "规则名称不能为空")
    @Length(max = 30)
    @ApiModelProperty("规则名字")
    private String name;

    /**
    * 规则类型
    */
    @NotNull(message = "规则类型不能为空")
    @Range(max = 1L)
    @ApiModelProperty("规则类型 (0=流程规则，1=评分规则）")
    private Integer type;

    /**
    * 模式
    */
    @NotNull(message = "模式不能为空")
    @Range(max = 1L)
    @ApiModelProperty("模式（0=全部满足，1=任意满足）")
    private Integer mode;

    /**
    * 规则决策
    */
    // @NotNull(message = "规则决策不能为空")
    @ApiModelProperty("规则决策 （type=1时，为权重分）")
    private Double decision;

    /**
    * 状态
    */
    @NotNull(message = "状态不能为空")
    @Range(max = 2L)
    @ApiModelProperty("状态 （0=启用，1=试运行，2=禁用）")
    private Integer status;

    /**
    * 描述
    */
    @ApiModelProperty("描述")
    private String description;

	/**
	 * 条件
	 */
	@NotEmpty(message = "条件不能为空")
	@Valid
	@ApiModelProperty("条件")
	private List<EngineConditionDto> conditions;

    /**
     * 规则后置行为
     */
    @ApiModelProperty("规则后置行为 " +
                      "NO_ACTION=默认值缺省  " +
                      "IP_BLACK=IP加入黑名单 " +
                      "DEVICE_BLACK=设备加入黑名单 " +
                      "UA_BLACK=UA加入黑名单    .")
	private RuleAction ruleAction = RuleAction.NO_ACTION;

    @ApiModelProperty("拓展关联维度:1-rid,2-uuid6,3-deviceId,4-ua,5-ip")
    private Integer relateType;

    /**
    * 创建者
    */
    private String creator;

    /**
    * 修改者
    */
    private String editor;

    /**
    * 创建时间
    */
    private Date gmtCreate;

    /**
    * 修改时间
    */
    private Date gmtModified;

}

