package cn.com.duiba.tuia.risk.center.api.dto.req;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.io.Serializable;
import java.util.Date;

@ApiModel
public class ReviewRecordParam implements Serializable {

    private static final long serialVersionUID = 3520238551392005230L;

    @ApiModelProperty("资源类型 0-活动，1-流量引导页，2-插件工具，3-素材")
    private Integer resourceType;

    @ApiModelProperty("资源ID")
    private Long resourceId;

    @ApiModelProperty("资源名字")
    private String resourceName;

    @ApiModelProperty("审核状态 0-拒绝，1-通过")
    private Integer reviewStatus;

    @ApiModelProperty("审核类型，0-初审，1-复审")
    private Integer reviewType;

    @ApiModelProperty("资源URL")
    private String resourceUrl;

    @ApiModelProperty("审核理由")
    private String reviewReason;

    @ApiModelProperty("审核时间")
    private Date reviewTime;

    @ApiModelProperty("提交时间")
    private Date commitTime;

    @ApiModelProperty("审核人")
    private String reviewer;

    public Integer getResourceType() {
        return resourceType;
    }

    public void setResourceType(Integer resourceType) {
        this.resourceType = resourceType;
    }

    public Long getResourceId() {
        return resourceId;
    }

    public void setResourceId(Long resourceId) {
        this.resourceId = resourceId;
    }

    public String getResourceName() {
        return resourceName;
    }

    public void setResourceName(String resourceName) {
        this.resourceName = resourceName;
    }

    public Integer getReviewStatus() {
        return reviewStatus;
    }

    public void setReviewStatus(Integer reviewStatus) {
        this.reviewStatus = reviewStatus;
    }

    public Integer getReviewType() {
        return reviewType;
    }

    public void setReviewType(Integer reviewType) {
        this.reviewType = reviewType;
    }

    public String getResourceUrl() {
        return resourceUrl;
    }

    public void setResourceUrl(String resourceUrl) {
        this.resourceUrl = resourceUrl;
    }

    public String getReviewReason() {
        return reviewReason;
    }

    public void setReviewReason(String reviewReason) {
        this.reviewReason = reviewReason;
    }

    public Date getReviewTime() {
        return reviewTime;
    }

    public void setReviewTime(Date reviewTime) {
        this.reviewTime = reviewTime;
    }

    public String getReviewer() {
        return reviewer;
    }

    public void setReviewer(String reviewer) {
        this.reviewer = reviewer;
    }

    public Date getCommitTime() {
        return commitTime;
    }

    public void setCommitTime(Date commitTime) {
        this.commitTime = commitTime;
    }
}
