package cn.com.duiba.tuia.risk.center.api.remoteservice;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.risk.center.api.common.PageResultDto;
import cn.com.duiba.tuia.risk.center.api.dto.SlotGuideList4Update;
import cn.com.duiba.tuia.risk.center.api.dto.SlotGuideListDto;
import cn.com.duiba.tuia.risk.center.api.dto.req.SlotGuideListParam;

import java.util.List;
import java.util.Map;

@AdvancedFeignClient
public interface RemoteSlotGuideListService {

    /**
     * @Description: 分页查询广告位导量信息
     * @Param:
     * @return:
     * @Author: lijian
     * @Date: 2018/12/07
     */
    PageResultDto<SlotGuideListDto> queryPage(SlotGuideListParam param);

    /**
     * @Description: 更新广告位导量名单规则发券比例
     * @Param:
     * @return:
     * @Author: lijian
     * @Date: 2018/12/07
     */
    Boolean updateLaunchRateByRule(SlotGuideList4Update slotGuideList4Update);

    /**
     * @Description: 更新广告位导量名单发券概率数据
     * @Param:
     * @return:
     * @Author: lijian
     * @Date: 2018/12/11
     */
    Boolean updateById(SlotGuideList4Update slotGuideList4Update);

    /**
     * 删除指定日期的广告位导量数据
     *
     * @param curDate 指定日期
     * @return 是否成功
     */
    Boolean deleteByCurDate(String curDate);

    /**
     * 手动新增广告位导量信息
     */
    Boolean addSlotGuideList(SlotGuideListDto dto);

    /**
     * 根据条件查询广告位导量信息的数量
     */
    Integer getCountByParam(SlotGuideListParam param);

    /**
     * 根据广告位列表获取实时导量广告位的发券量
     * @param slotIds
     * @return
     */
    Map<Long,Long> getLaunchData(List<Long> slotIds, Long minusDays);

    /**
     * 昨日A规则作弊数据相关指标更新定时任务
     */
    void processUpdateSlotSlotGuideList();

    /**
     * 发送用户导量到广告端
     */
    void sendToAdvert();

    /**
     * 计算获取当日导量广告位数据定时任务
     */
    void calSlotGuideSlotListProcess();

}
