package cn.com.duiba.tuia.risk.center.api.remoteservice;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.risk.center.api.common.PageResultDto;
import cn.com.duiba.tuia.risk.center.api.dto.domain.StrategyAdvertDto;
import cn.com.duiba.tuia.risk.center.api.dto.req.domain.StrategyAdvertParam;

import java.util.List;

/**
 * @ClassName StrategyAdvertService
 * @Description 策略关联广告表
 * @Author lijian
 * @Date 2020/5/7 15:04
 * @Version 1.0
 */
@AdvancedFeignClient
public interface RemoteStrategyAdvertService {

    /**
     * 域名策略关联广告 分页查询
     *
     * @param req
     * @return
     */
    PageResultDto<StrategyAdvertDto> queryPage(StrategyAdvertParam req);

    /**
     * 保存
     *
     * @param dto
     * @return
     */
    Integer save(StrategyAdvertDto dto);

    /**
     * 删除
     *
     * @param id
     * @return
     */
    Integer deleteById(Long id);

    /**
     * 根据 策略id查询关联广告  只用于ac-web  初始化缓存数据
     *
     * @param strategyIds
     * @return
     */
    List<StrategyAdvertDto> getStrategyAdverts(List<Long> strategyIds);

    /**
     * 根据广告id查询数据数量
     * @param advertId
     * @return
     */
    Integer getAdvertCount(Long advertId);

    /**
     * 根据广告id查询关联的策略
     * @param advertId
     * @return
     */
    StrategyAdvertDto getStrategyByAdvert(Long advertId);

    /**
     *  根据策略id删除关联的广告
     * @param strategyId
     * @return
     */
    Integer deleteByStrategy(Long strategyId);


}
