package cn.com.duiba.tuia.risk.center.api.dto;

import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import java.io.Serializable;
import java.util.Date;

/**
 * 手动送审媒体广告巡查审核表
 * @author lijicong
 * @since 2021-04-23
 */
@Getter
@Setter
public class RiskMediaReviewDTO implements Serializable {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty("")
    private Long id;

    @ApiModelProperty("广告ID")
    private Long advertId;

    @ApiModelProperty("巡查时间")
    private Date reviewTime;

    @ApiModelProperty("上次巡查时间")
    private Date lastReviewTime;

    @ApiModelProperty("上次OSS URL")
    private String lastUrl;

    @ApiModelProperty("本次OSS URL")
    private String currentUrl;

    @ApiModelProperty("差异度")
    private Integer diversityFactor;

    @ApiModelProperty("落地页连接")
    private String landingUrl;

    @ApiModelProperty("图片哈希值")
    private String hashDegree;

    @ApiModelProperty("创建时间")
    private Date gmtCreate;

    @ApiModelProperty("修改时间")
    private Date gmtModified;

}