package cn.com.duiba.tuia.risk.center.api.remoteservice;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.risk.center.api.common.PageResultDto;
import cn.com.duiba.tuia.risk.center.api.dto.CheatAppHandleDto;
import cn.com.duiba.tuia.risk.center.api.dto.DwsCheatAppHandleDto;
import cn.com.duiba.tuia.risk.center.api.dto.req.CheatAppHandleParam;

import java.util.List;

@AdvancedFeignClient
public interface RemoteCheatAppHandleService {

    /**
     * 查询广告位列表
     * @param param
     * @return
     */
    PageResultDto<CheatAppHandleDto> queryPage(CheatAppHandleParam param);

    /**
     * 新增广告位
     * @param param
     */
    Integer insert(CheatAppHandleParam param);


    /**
     * 编辑广告位
     * @param param
     */
    Integer edit(CheatAppHandleParam param);


    /**
     * 删除广告位
     * @param id
     */
    Integer delete(Long id);


    /**
     * 导出广告位列表
     * @param param
     */
    List<CheatAppHandleDto> export(CheatAppHandleParam param);


    /**
     * 查询arup趋势
     * @param param
     * @return
     */
    List<DwsCheatAppHandleDto> arupList(CheatAppHandleParam param);


    /**
     * 获取问题类型
     */
    List<String> getQuestType();


    /**
     * 查询已经插入的广告位
     */
    List<CheatAppHandleDto> selectCheatAppDataBySlotId(Long slotId);
}
