package cn.com.duiba.tuia.risk.center.api.enums;

import java.util.Arrays;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;

/**
 * 平台类型
 *
 * @author zhangbaiqiang
 * @date 2021/3/10
 */
public enum DomainPlatformEnum {

    WECHAT(1, "微信"),
    ALIPAY(2, "支付宝-安卓"),
    ALIPAY_IOS(3, "支付宝-IOS"),

    ;

    private Integer type;
    private String desc;

    private static Map<Integer, DomainPlatformEnum> map =
            Arrays.stream(DomainPlatformEnum.values()).collect(Collectors.toMap(DomainPlatformEnum::getType, v -> v));

    DomainPlatformEnum(Integer type, String desc) {
        this.type = type;
        this.desc = desc;
    }

    public Integer getType() {
        return type;
    }

    public String getDesc() {
        return desc;
    }

    public static DomainPlatformEnum of(Integer type) {
        return map.getOrDefault(type, DomainPlatformEnum.ALIPAY_IOS);
    }

    public static String getDescByType(Integer type) {
        return map.getOrDefault(type, DomainPlatformEnum.WECHAT).getDesc();
    }
}
