package cn.com.duiba.tuia.risk.center.api.remoteservice;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.risk.center.api.common.PageResultDto;
import cn.com.duiba.tuia.risk.center.api.dto.RefererSignDto;
import cn.com.duiba.tuia.risk.center.api.dto.req.RefererSignParam;

@AdvancedFeignClient
public interface RemoteRefererSignService {

    /**
     * 保存
     *
     * @param refererSignDto
     * @return
     */
    Integer save(RefererSignDto refererSignDto);

    /**
     * 删除
     *
     * @param id
     * @return
     */
    Integer deleteById(Long id);

    /**
     * 更新
     *
     * @param dto
     * @return
     */
    Integer updateById(RefererSignDto dto);

    /**
     * 根据Referer标识查询数据
     * @param refererSign
     * @return
     */
    RefererSignDto getByRefererSign(String refererSign);


    /**
     * 分页查询Referer标识页信息
     *
     * @param param
     * @return
     */
    PageResultDto<RefererSignDto> queryPage(RefererSignParam param);

    /**
     * 根据标识名称查询最新一条数据
     * @param signName
     * @return
     */
    RefererSignDto getLastBySignName(String signName);


    /**
     * 根据标识名称更新数据
     * @param dto
     * @return
     */
    Integer updateBySignName(RefererSignDto dto);

}
