package cn.com.duiba.tuia.risk.center.api.dto;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.io.Serializable;
import java.util.Date;
import java.util.List;

/**
 * 广告计划白名单
 */
@ApiModel
public class AdvertWhiteListDto implements Serializable {

    private static final long serialVersionUID = -7990788453435257723L;

    //广告计划
    public static final Integer ADVERT_TYPE = 0;
    //广告主
    public static final Integer ACCOUNT_TYPE = 1;

    private Long id;

    @ApiModelProperty("名单值id")
    private Long advertId;

    @ApiModelProperty("广告名称")
    private String advertName;

    @ApiModelProperty("广告主名称")
    private String advertMaster;

    @ApiModelProperty("名单场景 0-落地页返回拦截, 1-落地页篡改")
    private Integer sceneType;

    @ApiModelProperty("名单类型0:广告计划id；1:广告主id")
    private Integer valueType;

    @ApiModelProperty("创建人")
    private String creator;

    @ApiModelProperty("备注")
    private String description;

    @ApiModelProperty("创建时间")
    private Date gmtCreate;

    @ApiModelProperty("更新时间")
    private Date gmtModified;

    @ApiModelProperty("广告计划id列表")
    private List<Long> advertIds;

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Long getAdvertId() {
        return advertId;
    }

    public void setAdvertId(Long advertId) {
        this.advertId = advertId;
    }

    public String getAdvertName() {
        return advertName;
    }

    public void setAdvertName(String advertName) {
        this.advertName = advertName;
    }

    public String getAdvertMaster() {
        return advertMaster;
    }

    public void setAdvertMaster(String advertMaster) {
        this.advertMaster = advertMaster;
    }

    public Integer getSceneType() {
        return sceneType;
    }

    public void setSceneType(Integer sceneType) {
        this.sceneType = sceneType;
    }

    public Integer getValueType() {
        return valueType;
    }

    public void setValueType(Integer valueType) {
        this.valueType = valueType;
    }

    public String getCreator() {
        return creator;
    }

    public void setCreator(String creator) {
        this.creator = creator;
    }

    public String getDescription() {
        return description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public Date getGmtCreate() {
        return gmtCreate;
    }

    public void setGmtCreate(Date gmtCreate) {
        this.gmtCreate = gmtCreate;
    }

    public Date getGmtModified() {
        return gmtModified;
    }

    public void setGmtModified(Date gmtModified) {
        this.gmtModified = gmtModified;
    }

    public List<Long> getAdvertIds() {
        return advertIds;
    }

    public void setAdvertIds(List<Long> advertIds) {
        this.advertIds = advertIds;
    }
}
