package cn.com.duiba.tuia.risk.center.api.dto.domain;

import lombok.Data;
import lombok.ToString;

import java.io.Serializable;
import java.util.Date;

/**
 * 域名告警DTO
 *
 * @author peanut.huang
 * @date 2019/10/23
 * @since JDK 1.8
 */
@Data
@ToString
public class DomainAlarmDTO implements Serializable{

    private static final long serialVersionUID = -7772096397011064661L;


    /**
     * 域名记录id
     */
    private Long        id;

    /**
     * 平台类型 {@link cn.com.duiba.tuia.risk.center.api.enums.DomainPlatformEnum#type}
     */
    private Integer     platformType;

    /**
     * 域名类型 {@link cn.com.duiba.tuia.risk.center.api.enums.DomainTypeEnum#status}
     */
    private Integer     domainType;

    /**
     * 有效域名库存
     */
    private Integer     domainStock;

    /**
     * 域名告警阈值
     */
    private Integer     alarmThreshold;

    /**
     * 域名告警接收人，名称:adminId,如：xx:1,xx:2,xx:3
     */
    private String      alarmMen;

    /**
     * 添加人名称
     */
    private String      adminName;

    /**
     * 创建时间
     */
    private Date        gmtCreate;

    /** 新行业标签 -1:不限 */
    private String newTrade;
}
