package cn.com.duiba.tuia.risk.center.api.remoteservice;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.risk.center.api.common.PageResultDto;
import cn.com.duiba.tuia.risk.center.api.dto.PackageNameSignDto;
import cn.com.duiba.tuia.risk.center.api.dto.req.PackageNameSignParam;

@AdvancedFeignClient
public interface RemotePackageNameSignService {

    /**
     * 保存
     *
     * @param packageNameSignDto
     * @return
     */
    Integer save(PackageNameSignDto packageNameSignDto);

    /**
     * 删除
     *
     * @param id
     * @return
     */
    Integer deleteById(Long id);

    /**
     * 更新
     *
     * @param dto
     * @return
     */
    Integer updateById(PackageNameSignDto dto);

    /**
     * 根据PackageName标识查询数据
     * @param packageNameSign
     * @return
     */
    PackageNameSignDto getByPackageNameSign(String packageNameSign);


    /**
     * 分页查询PackageName标识页信息
     *
     * @param param
     * @return
     */
    PageResultDto<PackageNameSignDto> queryPage(PackageNameSignParam param);

    /**
     * 根据标识名称查询最新一条数据
     * @param signName
     * @return
     */
    PackageNameSignDto getLastBySignName(String signName);

    /**
     * 根据标识名称更新
     * @param dto
     * @return
     */
    Integer updateBySignName(PackageNameSignDto dto);

}
