package cn.com.duiba.tuia.risk.center.api.remoteservice;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.risk.center.api.dto.RiskCheatStopDto;

import java.util.Date;
import java.util.List;

@AdvancedFeignClient
public interface RemoteRiskCheatStopService {
    /**
     * 根据日期范围获取 作弊流量 arpu 的基础指标
     *
     * @param beginDate
     * @param endDate
     * @return
     */
    List<RiskCheatStopDto> getByCurDate(String beginDate, String endDate);

    /**
     * 根据日期列表获取 作弊流量 arpu 的基础指标
     *
     * @param curDates
     * @return
     */
    List<RiskCheatStopDto> getByCurDateList(List<Date> curDates);
}
