/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.tuia.risk.center.api.util;

import java.math.BigDecimal;
import java.text.NumberFormat;
import java.text.ParseException;

public class MathUtil {
    private static final int MULTIPLIER = 100;

    private MathUtil() {
    }

    public static String yuan2Fen(String yuan) throws ParseException {
        NumberFormat format = NumberFormat.getInstance();
        Number number = format.parse(yuan);
        double temp = number.doubleValue() * 100.0;
        format.setGroupingUsed(false);
        format.setMaximumFractionDigits(0);
        return format.format(temp);
    }

    public static String yuan2Fen(int yuan) {
        NumberFormat format = NumberFormat.getInstance();
        double temp = (double)yuan * 100.0;
        format.setGroupingUsed(false);
        format.setMaximumFractionDigits(0);
        return format.format(temp);
    }

    public static String fen2Yuan(String fen) {
        return new BigDecimal(fen).divide(new BigDecimal(100)).setScale(2).toString();
    }

    public static String fen2Yuan(int fen) {
        return new BigDecimal(fen).divide(new BigDecimal(100)).setScale(2).toString();
    }

    public static BigDecimal calculateRate(Long divisor, Long dividend) {
        BigDecimal result = BigDecimal.ZERO;
        if (divisor != null && dividend != null && dividend != 0L) {
            BigDecimal bigDivisor = new BigDecimal(divisor);
            BigDecimal bigDividend = new BigDecimal(dividend);
            return bigDivisor.multiply(new BigDecimal(100)).divide(bigDividend, 3, 4);
        }
        return result;
    }

    public static BigDecimal calRate(Long divisor, Long dividend) {
        BigDecimal result = BigDecimal.ZERO;
        if (divisor != null && dividend != null && dividend != 0L) {
            BigDecimal bigDivisor = new BigDecimal(divisor);
            BigDecimal bigDividend = new BigDecimal(dividend);
            return bigDivisor.divide(bigDividend, 4, 4);
        }
        return result;
    }

    public static BigDecimal calSubtract(BigDecimal val1, BigDecimal val2) {
        if (val1 != null && val2 != null) {
            return val1.subtract(val2).setScale(4, 4);
        }
        return null;
    }

    public static Double calDoubleRate(Long divisor, Long dividend) {
        BigDecimal result = BigDecimal.ZERO;
        if (divisor != null && dividend != null && dividend != 0L) {
            BigDecimal bigDivisor = new BigDecimal(divisor);
            BigDecimal bigDividend = new BigDecimal(dividend);
            return bigDivisor.divide(bigDividend, 4, 4).doubleValue();
        }
        return result.doubleValue();
    }

    public static Double calDoubleRate(Double divisor, Double dividend) {
        BigDecimal result = BigDecimal.ZERO;
        if (divisor != null && dividend != null && dividend != 0.0) {
            BigDecimal bigDivisor = new BigDecimal(divisor);
            BigDecimal bigDividend = new BigDecimal(dividend);
            return bigDivisor.divide(bigDividend, 4, 4).doubleValue();
        }
        return result.doubleValue();
    }

    public static Long calAddition(Long val1, Long val2) {
        if (val1 == null) {
            val1 = 0L;
        }
        if (val2 == null) {
            val2 = 0L;
        }
        return val1 + val2;
    }
}

