package cn.com.duiba.tuia.risk.center.api.dto;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;
import java.util.List;

/**
* 广告主信用分表
*/
@Data
@ApiModel
public class AccountCreditInfoDto implements Serializable {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty("主键")
    private Long id;

    @ApiModelProperty("广告主id")
    private Long accountId;

    @ApiModelProperty("广告主名称")
    private String accountName;

    @ApiModelProperty("代理商id")
    private Long agentId;

    @ApiModelProperty("代理商名称")
    private String agentName;

    @ApiModelProperty("信用分")
    private Integer creditScore;

    @ApiModelProperty("AE")
    private String aeName;

    @ApiModelProperty("销售")
    private String saleName;

    @ApiModelProperty("操作人员")
    private String opreateName;

    @ApiModelProperty("是否黑名单：0-否，1-是")
    private Integer blackType;

    @ApiModelProperty("创建时间")
    private Date gmtCreate;

    @ApiModelProperty("修改时间")
    private Date gmtModified;

    @ApiModelProperty("广告主信用分变更记录")
    private List<AccountCreditLogDto> accountLogList;


}

