package cn.com.duiba.tuia.risk.center.api.remoteservice;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.risk.center.api.common.PageResultDto;
import cn.com.duiba.tuia.risk.center.api.dto.AuditPunishRecordDto;
import cn.com.duiba.tuia.risk.center.api.dto.req.AuditPunishRecordParam;

import java.util.List;

/**
 * 违规处罚积分日志表
 */
@AdvancedFeignClient
public interface RemoteAuditPunishRecordService {

    /**
     * 保存
     *
     * @param dto
     * @return
     */
    Integer save(AuditPunishRecordDto dto);

    /**
     * 更新
     *
     * @param dto
     * @return
     */
    Integer updateById(AuditPunishRecordDto dto);

    /**
     * 根据ID查询日志信息
     *
     * @param id
     * @return
     */
    AuditPunishRecordDto getById(Long id);

    /**
     * 分页查询
     *
     * @param param
     * @return
     */
    PageResultDto<AuditPunishRecordDto> queryPage(AuditPunishRecordParam param);

    /**
     * 根据条件查询处罚日志
     *
     * @param param
     * @return
     */
    List<AuditPunishRecordDto> getPunishRecordByParam(AuditPunishRecordParam param);

    /**
     * 获取 季度和广告主ID维度的处罚汇总分
     *
     * @param tbQuarter
     * @param accountId
     * @return
     */
    Integer getQuarterSumSore(String tbQuarter, Long accountId);

    /**
     * 根据广告主名称和季度查询审核拒绝记录信息
     *
     * @param advertMasters
     * @param tbQuarter
     * @return
     */
    List<AuditPunishRecordDto> getRecordByMaster(List<String> advertMasters, String tbQuarter);


}
