package cn.com.duiba.tuia.risk.center.api.common;

import java.util.List;

/**
 * Abstract interface for pagination information.
 *
 * @author ikongyi
 */
public interface Pageable {

    /**
     * Returns the number of items to be returned.
     *
     * @return the number of items of that page
     */
    Integer getPageSize();

    /**
     * Returns the offset to be taken according to the underlying page and page size.
     *
     * @return the offset to be taken
     */
    Integer getOffset();

    /**
     * Returns the sorting parameters.
     *
     * @return
     */
    List<OrderBy> getSort();
}