package cn.com.duiba.tuia.risk.center.api.dto;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.io.Serializable;
import java.util.Date;

/**
 * 广告主信用分变更表
 */
@ApiModel
public class AccountCreditLogDto implements Serializable {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty("主键")
    private Long id;

    @ApiModelProperty("广告主id")
    private Long accountId;

    @ApiModelProperty("考核维度：1-黑名单、2-个人信息不全、3-kyc无认证、4-a级客诉、5-失信-落地页篡改、6-失信-综合日志库、7-守信奖励、8-其他 ")
    private Integer checkType;

    @ApiModelProperty("具体内容")
    private String checkContext;

    @ApiModelProperty("变更分值")
    private Integer dealScore;


    @ApiModelProperty("操作人员")
    private String opreateName;

    /**
     * 创建时间
     */
    private Date gmtCreate;

    /**
     * 修改时间
     */
    private Date gmtModified;


    public void setId(Long id) {
        this.id = id;
    }

    public Long getId() {
        return id;
    }

    public void setAccountId(Long accountId) {
        this.accountId = accountId;
    }

    public Long getAccountId() {
        return accountId;
    }

    public void setCheckType(Integer checkType) {
        this.checkType = checkType;
    }

    public Integer getCheckType() {
        return checkType;
    }

    public void setCheckContext(String checkContext) {
        this.checkContext = checkContext;
    }

    public String getCheckContext() {
        return checkContext;
    }

    public void setDealScore(Integer dealScore) {
        this.dealScore = dealScore;
    }

    public Integer getDealScore() {
        return dealScore;
    }

    public void setOpreateName(String opreateName) {
        this.opreateName = opreateName;
    }

    public String getOpreateName() {
        return opreateName;
    }

    public void setGmtCreate(Date gmtCreate) {
        this.gmtCreate = gmtCreate;
    }

    public Date getGmtCreate() {
        return gmtCreate;
    }

    public void setGmtModified(Date gmtModified) {
        this.gmtModified = gmtModified;
    }

    public Date getGmtModified() {
        return gmtModified;
    }

}

