package cn.com.duiba.tuia.risk.center.api.dto;

import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
* 素材/落地页复审信息表
*/
@Data
public class MaterialPromoteRecheckDto implements Serializable {

    private static final long serialVersionUID = 1L;
    //通过
    public   static Integer PASS=1;
    //拒绝
    public static Integer REJECT=0;

    /**素材*/
    public static Integer SOURCETYPEMATERIAL=0;
    /**落地页*/
    public static Integer SOURCETYPEPROMOTE=1;


    /**等待复审
     */
    public static Integer SECONDCHECKSTATE_ING=0;
    /**以复审完毕
     */
    public static Integer SECONDCHECKSTATE_END=1;
    /**等待三方复审
     */
    public static Integer SECONDCHECKSTATE_ING_THREE=2;
    /**三方复审完毕
     */
    public static Integer SECONDCHECKSTATE_END_THREE=3;
    /**
    * id
    */
    private Long id;

    /**
    * 广告id
    */
    private Long advertId;

    /**
    * 资源id(落地页/素材id)
    */
    private Long sourceId;

    /**
    * 资源名称
    */
    private String sourceName;

    /**
    * 广告主名称
    */
    private String advertiserName;

    /**
    * 代理商名称
    */
    private String agentName;

    /**
    * 首次审核人(广告管理系统那边的审核结果)
    */
    private String firstReviewer;

    /**
    * 首次审核结果(广告管理系统那边的审核结果)
    */
    private Integer firstReviewResult;

    /**
    * 首次审核绑定的落地页/素材(广告管理系统那边的审核结果) 1,2,3
    */
    private String firstBindSource;

    /**
    * 首次审核可以看见的落地页列表（用于复审时候查询 初审当初可见的列表）
    */
    private String firstSeeSourceMateriaIds;

    /**
     * 首次审核可以看见的素材列表（用于复审时候查询 初审当初可见的列表）
     */
    private String firstSeeSourcePromoteIds;

    /**
    * 首次审核绑定的落地页/素材打表信息
    */
    private String firstBindTag;

    /**
    * 钟馗去广告平台复审 绑定素材/落地页
    */
    private String secondBindSource;

    /**
    * 钟馗去广告平台复审 打素材/落地页标签
    */
    private String secondBindTag;

    /**
    * 钟馗复审状态/0代复审 1已经复审 2 待三方复审 3三方已复审
    */
    private Integer secondCheckState;

    /**
    * 复审人
    */
    private String secondReviewr;

    /**
    * 复审通过/拒绝
    */
    private Integer secondReviewResult;

    /**
    * 第三方复审人
    */
    private String threeReviewer;

    /**
    * 三方复审结论
    */
    private String threeMemo;

    /**
    * 最终审核结果/首次审核 或者复审后的结果 0false 1true 
    */
    private Integer lastReviewResult;

    /**
    * 最近审核时间-指的是首次审核时间(广告管理系统那边的
    */
    private Date lastReviewTime;

    /**
    * 0是素材 1是落地页
    */
    private Integer sourceType;

    /**
    * 销售名称
    */
    private String sale;

    /**
    * ae名称
    */
    private String ae;

    /**
    * 创建时间
    */
    private Date gmtCreate;

    /**
    * 更新时间
    */
    private Date gmtModified;
    /**
     * 素材类型的数据有这个字段 1其他类型素材 2adx类型的素材
     * @author fanjia
     * @date 2021/11/1 上午9:39

     */
    private Integer advertMaterialType;


    /**
     * 复审时间
     * @author fanjia
     * @date 2021/11/4 下午3:36

     */
    private Date secondReviewTime;


    /**
     *  复审落地页截图
     * @author fanjia
     * @date 2021/11/4 下午3:36
     */
    private String secondPromoteImg;
}

