package cn.com.duiba.tuia.risk.center.api.remoteservice;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.risk.center.api.common.PageResultDto;
import cn.com.duiba.tuia.risk.center.api.dto.MediaBlackDto;
import cn.com.duiba.tuia.risk.center.api.dto.UaSignDto;
import cn.com.duiba.tuia.risk.center.api.dto.req.MediaBlackParam;
import cn.com.duiba.tuia.risk.center.api.dto.req.UaSignParam;

@AdvancedFeignClient
public interface RemoteUaSignService {

    /**
     * 保存
     * @param uaSignDto
     * @return
     */
    Integer save(UaSignDto uaSignDto);

    /**
     * 删除
     * @param id
     * @return
     */
    Integer deleteById(Long id);

    /**
     * 更新
     * @param dto
     * @return
     */
    Integer updateById(UaSignDto dto);

    /**
     * 根据ua 一级二级标签查询数据
     * @param uaOneGrade
     * @param uaTwoGrade
     * @return
     */
    UaSignDto getByOneTwo(String uaOneGrade, String uaTwoGrade);


    /**
     * 分页查询UserAgent标识页信息
     * @param param
     * @return
     */
    PageResultDto<UaSignDto> queryPage(UaSignParam param);

    /**
     * 根据标识名称查询最新一条数据
     * @param signName
     * @return
     */
    UaSignDto getLastBySignName(String signName);

    /**
     * 根据标识名称更新数据
     * @param dto
     * @return
     */
    Integer updateBySignName(UaSignDto dto);

}
