package cn.com.duiba.tuia.risk.center.api.remoteservice;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.risk.center.api.dto.AccountUnsealDto;

import java.util.List;

/**
 * 广告主季度违规处罚积分账户解封表
 */
@AdvancedFeignClient
public interface RemoteAccountUnsealService {

    /**
     * 保存
     *
     * @param dto
     * @return
     */
    Integer save(AccountUnsealDto dto);

    /**
     * 更新
     *
     * @param dto
     * @return
     */
    Integer updateById(AccountUnsealDto dto);

    /**
     * 根据条件更新
     * @param dto
     * @return
     */
    Integer updateByParam(AccountUnsealDto dto);

    /**
     * 获取待解封的广告主数据
     * @return
     */
    List<AccountUnsealDto> getByQuarterAndAccount(String tbQuarter, Long accountId, Integer tbUnseal);


}
