package cn.com.duiba.tuia.risk.center.api.remoteservice;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.risk.center.api.common.PageResultDto;
import cn.com.duiba.tuia.risk.center.api.dto.AdvertSecondReviewDto;
import cn.com.duiba.tuia.risk.center.api.dto.MaterialPromoteRecheckDto;
import cn.com.duiba.tuia.risk.center.api.dto.req.MaterialPromoteRecheckParam;
import cn.com.duiba.tuia.risk.center.api.dto.req.SecondReviewSearchParam;

import java.util.List;
import java.util.Optional;

/**
 *  落地页素材复审
 * @author fanjia
 */
@AdvancedFeignClient
public interface RemoteMaterialPromoteRecheckService {

    // 复审列表
    PageResultDto<MaterialPromoteRecheckDto> queryPage(MaterialPromoteRecheckParam param);

    Integer save(MaterialPromoteRecheckDto materialPromoteRecheckDto);

    Integer updateById(MaterialPromoteRecheckDto materialPromoteRecheckDto);

    Optional<MaterialPromoteRecheckDto> getById(Long id);

    /**
     *
     * @author fanjia
     * @date 2021/11/2 下午6:03
     * @param sourceId
     * @param sourceType 0是素材 1是落地页
     * @return java.util.Optional<cn.com.duiba.tuia.risk.center.api.dto.MaterialPromoteRecheckDto>
     */
    Optional<MaterialPromoteRecheckDto>   getLastRecordBySourceIAndSourceType(Long sourceId,Integer sourceType);

    /**
     *  根据类型查询相应的所有的初审人名称
     * @author fanjia
     * @date 2021/11/5 上午9:51
     * @param sourceType
     * @return java.util.List<java.lang.String>
     */
    List<String> getAllReviewers(Integer sourceType);
}

