package cn.com.duiba.tuia.risk.center.api.dto;


import java.io.Serializable;

public class MediaPropDto implements Serializable {

    private static final long serialVersionUID = 1L;

	private Long appId;
	private String appName;
	private Long slotId;
	private String slotName;

	public Long getAppId() {
		return appId;
	}

	public void setAppId(Long appId) {
		this.appId = appId;
	}

	public String getAppName() {
		return appName;
	}

	public void setAppName(String appName) {
		this.appName = appName;
	}

	public Long getSlotId() {
		return slotId;
	}

	public void setSlotId(Long slotId) {
		this.slotId = slotId;
	}

	public String getSlotName() {
		return slotName;
	}

	public void setSlotName(String slotName) {
		this.slotName = slotName;
	}

	@Override
	public boolean equals(Object o) {
		if (this == o) return true;
		if (o == null || getClass() != o.getClass()) return false;

		MediaPropDto that = (MediaPropDto) o;

		if (appId != null ? !appId.equals(that.appId) : that.appId != null) return false;
		if (appName != null ? !appName.equals(that.appName) : that.appName != null) return false;
		if (slotId != null ? !slotId.equals(that.slotId) : that.slotId != null) return false;
		return slotName != null ? slotName.equals(that.slotName) : that.slotName == null;
	}

	@Override
	public int hashCode() {
		int result = appId != null ? appId.hashCode() : 0;
		result = 31 * result + (appName != null ? appName.hashCode() : 0);
		result = 31 * result + (slotId != null ? slotId.hashCode() : 0);
		result = 31 * result + (slotName != null ? slotName.hashCode() : 0);
		return result;
	}

	@Override
	public String toString() {
		return "MediaPropDto{" + "appId=" + appId + ", appName='" + appName + '\'' + ", slotId=" + slotId + ", slotName='" + slotName + '\'' + '}';
	}
}
