package cn.com.duiba.tuia.risk.center.api.dto.req.domain;

import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.ToString;

import cn.com.duiba.tuia.risk.center.api.dto.req.ReqPageQuery;

/**
 * 域名分页查询参数
 *
 * @author peanut.huang
 * @date 2019/10/23
 * @since JDK 1.8
 */
@EqualsAndHashCode(callSuper = true)
@Data
@ToString
public class PagingDomainParam extends ReqPageQuery {

    private static final long serialVersionUID = 2437033078501798713L;

    /**
     * 域名地址
     */
    private String      domain;

    /**
     * 域名类型 {@link cn.com.duiba.tuia.risk.center.api.enums.DomainTypeEnum#status}
     */
    private Integer     domainType;

    /**
     * 域名状态 {@link cn.com.duiba.tuia.risk.center.api.enums.DomainStatusEnum#status}
     */
    private Integer     domainStatus;

    /**
     * 域名在微信的投放状态 {@link cn.com.duiba.tuia.risk.center.api.enums.DomainWXStatusEnum#status}
     */
    private Integer     wxStatus;

    /**
     * 域名在支付宝安卓的投放状态 {@link cn.com.duiba.tuia.risk.center.api.enums.DomainWXStatusEnum#status}
     */
    private Integer     alipayStatus;

    /**
     * 域名管理策略id::tb_domain_strategy.id 默认0 全局
     */
    private Long strategyId;

    /**新行业标签 -1:不限*/
    private String newTrade;

    /**域名在支付宝IOS的投放状态*/
    private Integer alipayIosStatus;

    /**
     * 是否开启域名替换 1.是 0.否
     */
    private Integer replaceDomain;
}
