package cn.com.duiba.tuia.risk.center.api.enums;

import java.util.Objects;
import java.util.stream.Stream;

/**
 * 解析状态
 *
 * @author lijian
 * @date 2019/12/02
 * @since JDK 1.8
 */
public enum AnalysisStatusEnum {

    ANALYSIS_FALSE(0, "解析失败"),
    ANALYSIS_TRUE(1, "解析成功");

    /**
     * 状态值
     */
    private Integer status;

    /**
     * 描述
     */
    private String desc;

    AnalysisStatusEnum(Integer status, String desc) {
        this.status = status;
        this.desc = desc;
    }

    public Integer getStatus() {
        return status;
    }

    public String getDesc() {
        return desc;
    }


    /**
     * 根据状态值获取枚举
     *
     * @param status 状态值
     * @return
     */
    public static AnalysisStatusEnum findByStatus(Integer status) {
        if (status == null) {
            return null;
        }
        return Stream.of(AnalysisStatusEnum.values()).filter(e -> Objects.equals(e.getStatus(), status)).findFirst().orElse(null);
    }
}
