package cn.com.duiba.tuia.risk.center.api.enums;

import lombok.Getter;

/**
 * @Author lijian
 * @Date 2021/7/26
 * @Description
 * @Param
 * @return
 **/
@Getter
public enum UrlTypeEnum {

    //url类型:0-落地页;1-二次跳转页面;2-配置落地页;3-ABTest落地页;4-素材绑定落地页;5-新媒体落地页
    ADVERT_PROMOTION(0, "广告推广链接"),
    TWO_JUMP(1, "二次跳转链接"),
    DIRECTIONAL_CONFIGURATION(2, "配置链接"),
    AB_TEST(3, "AB测试链接"),
    MATERIAL_BING_LAND_PAGE_TEST(4, "素材绑定落地页测试链接"),
    NEW_MEDIA_TEST(5, "新媒体测试链接"),
    JUMP_URL(6, "非推广链接的落地页二跳链接"),
    ;

    private Integer code;

    private String desc;

    UrlTypeEnum(Integer code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public static String getDescByCode(Integer code) {
        for (UrlTypeEnum urlTypeEnum : UrlTypeEnum.values()) {
            if (urlTypeEnum.getCode().equals(code)) {
                return urlTypeEnum.desc;
            }
        }
        return "";
    }

}
